/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.sms;

import com.azure.communication.sms.SmsAsyncClient;
import com.azure.communication.sms.SmsClientBuilder;
import com.azure.communication.sms.models.SmsSendOptions;
import com.azure.communication.sms.models.SmsSendResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=SmsClientBuilder.class)
public final class SmsClient {
    private final SmsAsyncClient smsAsyncClient;

    SmsClient(SmsAsyncClient smsAsyncClient) {
        this.smsAsyncClient = smsAsyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SmsSendResult send(String from, String to, String message) {
        return (SmsSendResult)this.smsAsyncClient.send(from, to, message).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SmsSendResult send(String from, String to, String message, SmsSendOptions options) {
        return (SmsSendResult)this.smsAsyncClient.send(from, to, message, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Iterable<SmsSendResult> send(String from, Iterable<String> to, String message) {
        return (Iterable)this.smsAsyncClient.send(from, to, message).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Iterable<SmsSendResult>> sendWithResponse(String from, Iterable<String> to, String message, SmsSendOptions options, Context context) {
        return (Response)this.smsAsyncClient.sendWithResponse(from, to, message, options, context).block();
    }
}

