/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.sms;

import com.azure.communication.sms.SmsClientBuilder;
import com.azure.communication.sms.implementation.AzureCommunicationSMSServiceImpl;
import com.azure.communication.sms.implementation.SmsImpl;
import com.azure.communication.sms.implementation.models.SendMessageRequest;
import com.azure.communication.sms.implementation.models.SmsRecipient;
import com.azure.communication.sms.implementation.models.SmsSendResponse;
import com.azure.communication.sms.implementation.models.SmsSendResponseItem;
import com.azure.communication.sms.models.SmsSendOptions;
import com.azure.communication.sms.models.SmsSendResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SmsClientBuilder.class, isAsync=true)
public final class SmsAsyncClient {
    private final SmsImpl smsClient;
    private final ClientLogger logger = new ClientLogger(SmsAsyncClient.class);

    SmsAsyncClient(AzureCommunicationSMSServiceImpl smsServiceClient) {
        this.smsClient = smsServiceClient.getSms();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SmsSendResult> send(String from, String to, String message) {
        return this.send(from, to, message, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SmsSendResult> send(String from, String to, String message, SmsSendOptions options) {
        return this.send(from, to, message, options, null);
    }

    Mono<SmsSendResult> send(String from, String to, String message, SmsSendOptions options, Context context) {
        try {
            Objects.requireNonNull(from, "'from' cannot be null.");
            Objects.requireNonNull(to, "'to' cannot be null.");
            List<String> recipients = Arrays.asList(to);
            SendMessageRequest request = this.createSendMessageRequest(from, recipients, message, options);
            return FluxUtil.withContext(contextValue -> {
                if (context != null) {
                    contextValue = context;
                }
                return this.smsClient.sendAsync(request, (Context)contextValue).flatMap(response -> {
                    List<SmsSendResult> smsSendResults = this.convertSmsSendResults(response.getValue());
                    return Mono.just((Object)smsSendResults.get(0));
                });
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Iterable<SmsSendResult>> send(String from, Iterable<String> to, String message) {
        return this.sendWithResponse(from, to, message, null).map(response -> (Iterable)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Iterable<SmsSendResult>>> sendWithResponse(String from, Iterable<String> to, String message, SmsSendOptions options) {
        return this.sendWithResponse(from, to, message, options, null);
    }

    Mono<Response<Iterable<SmsSendResult>>> sendWithResponse(String from, Iterable<String> to, String message, SmsSendOptions options, Context context) {
        try {
            Objects.requireNonNull(from, "'from' cannot be null.");
            Objects.requireNonNull(to, "'to' cannot be null.");
            SendMessageRequest request = this.createSendMessageRequest(from, to, message, options);
            return FluxUtil.withContext(contextValue -> {
                if (context != null) {
                    contextValue = context;
                }
                return this.smsClient.sendWithResponseAsync(request, (Context)contextValue).flatMap(response -> {
                    List<SmsSendResult> smsSendResults = this.convertSmsSendResults(((SmsSendResponse)response.getValue()).getValue());
                    return Mono.just((Object)new SimpleResponse(response, smsSendResults));
                });
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private List<SmsSendResult> convertSmsSendResults(Iterable<SmsSendResponseItem> resultsIterable) {
        ArrayList<SmsSendResult> iterableWrapper = new ArrayList<SmsSendResult>();
        for (SmsSendResponseItem item : resultsIterable) {
            iterableWrapper.add(new SmsSendResult(item.getTo(), item.getMessageId(), item.getHttpStatusCode(), item.isSuccessful(), item.getErrorMessage()));
        }
        return iterableWrapper;
    }

    private SendMessageRequest createSendMessageRequest(String from, Iterable<String> smsRecipient, String message, SmsSendOptions options) {
        SendMessageRequest request = new SendMessageRequest();
        ArrayList<SmsRecipient> recipients = new ArrayList<SmsRecipient>();
        for (String s : smsRecipient) {
            SmsRecipient recipient = new SmsRecipient().setTo(s).setRepeatabilityRequestId(UUID.randomUUID().toString()).setRepeatabilityFirstSent(OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("E, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US)));
            recipients.add(recipient);
        }
        request.setFrom(from).setSmsRecipients(recipients).setMessage(message).setSmsSendOptions(options);
        return request;
    }
}

