/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberAvailabilityStatus;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberCost;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AvailablePhoneNumber
implements JsonSerializable<AvailablePhoneNumber> {
    private String id;
    private String countryCode;
    private String phoneNumber;
    private PhoneNumberCapabilities capabilities;
    private PhoneNumberType phoneNumberType;
    private PhoneNumberAssignmentType assignmentType;
    private PhoneNumberCost cost;
    private PhoneNumberAvailabilityStatus status;
    private Boolean isAgreementToNotResellRequired;
    private ResponseError error;

    public String getId() {
        return this.id;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public PhoneNumberCost getCost() {
        return this.cost;
    }

    public PhoneNumberAvailabilityStatus getStatus() {
        return this.status;
    }

    public Boolean isAgreementToNotResellRequired() {
        return this.isAgreementToNotResellRequired;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.countryCode != null) {
            jsonWriter.writeStringField("countryCode", this.countryCode);
        }
        if (this.capabilities != null) {
            jsonWriter.writeFieldName("capabilities");
            this.capabilities.toJson(jsonWriter);
        }
        if (this.phoneNumberType != null) {
            jsonWriter.writeStringField("phoneNumberType", this.phoneNumberType.toString());
        }
        if (this.assignmentType != null) {
            jsonWriter.writeStringField("assignmentType", this.assignmentType.toString());
        }
        if (this.id != null) {
            jsonWriter.writeStringField("id", this.id);
        }
        if (this.phoneNumber != null) {
            jsonWriter.writeStringField("phoneNumber", this.phoneNumber);
        }
        if (this.cost != null) {
            jsonWriter.writeFieldName("cost");
            this.cost.toJson(jsonWriter);
        }
        if (this.status != null) {
            jsonWriter.writeStringField("status", this.status.toString());
        }
        if (this.isAgreementToNotResellRequired != null) {
            jsonWriter.writeBooleanField("isAgreementToNotResellRequired", this.isAgreementToNotResellRequired);
        }
        return jsonWriter.writeEndObject();
    }

    public static AvailablePhoneNumber fromJson(JsonReader jsonReader) throws IOException {
        return (AvailablePhoneNumber)jsonReader.readObject(reader -> {
            AvailablePhoneNumber deserializedAvailablePhoneNumber = new AvailablePhoneNumber();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("countryCode".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.countryCode = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.capabilities = PhoneNumberCapabilities.fromJson(reader);
                    continue;
                }
                if ("phoneNumberType".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                    continue;
                }
                if ("assignmentType".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.assignmentType = PhoneNumberAssignmentType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.id = reader.getString();
                    continue;
                }
                if ("phoneNumber".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.phoneNumber = reader.getString();
                    continue;
                }
                if ("cost".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.cost = PhoneNumberCost.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.status = PhoneNumberAvailabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("isAgreementToNotResellRequired".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.isAgreementToNotResellRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailablePhoneNumber;
        });
    }
}

