// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a trunk route for routing calls.
 */
@Fluent
public final class SipTrunkRoute implements JsonSerializable<SipTrunkRoute> {
    /*
     * Gets or sets description of the route.
     */
    @Generated
    private String description;

    /*
     * Gets or sets name of the route.
     */
    @Generated
    private String name;

    /*
     * Gets or sets regex number pattern for routing calls. .NET regex format is supported.
     * The regex should match only digits with an optional '+' prefix without spaces.
     * I.e. "^\+[1-9][0-9]{3,23}$".
     */
    @Generated
    private String numberPattern;

    /*
     * Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN.
     */
    @Generated
    private List<String> trunks;

    /**
     * Creates an instance of SipTrunkRoute class.
     */
    @Generated
    public SipTrunkRoute() {
    }

    /**
     * Get the description property: Gets or sets description of the route.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Gets or sets description of the route.
     * 
     * @param description the description value to set.
     * @return the SipTrunkRoute object itself.
     */
    @Generated
    public SipTrunkRoute setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the name property: Gets or sets name of the route.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Gets or sets name of the route.
     * 
     * @param name the name value to set.
     * @return the SipTrunkRoute object itself.
     */
    @Generated
    public SipTrunkRoute setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the numberPattern property: Gets or sets regex number pattern for routing calls. .NET regex format is
     * supported.
     * The regex should match only digits with an optional '+' prefix without spaces.
     * I.e. "^\+[1-9][0-9]{3,23}$".
     * 
     * @return the numberPattern value.
     */
    @Generated
    public String getNumberPattern() {
        return this.numberPattern;
    }

    /**
     * Set the numberPattern property: Gets or sets regex number pattern for routing calls. .NET regex format is
     * supported.
     * The regex should match only digits with an optional '+' prefix without spaces.
     * I.e. "^\+[1-9][0-9]{3,23}$".
     * 
     * @param numberPattern the numberPattern value to set.
     * @return the SipTrunkRoute object itself.
     */
    @Generated
    public SipTrunkRoute setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
        return this;
    }

    /**
     * Get the trunks property: Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN.
     * 
     * @return the trunks value.
     */
    @Generated
    public List<String> getTrunks() {
        return this.trunks;
    }

    /**
     * Set the trunks property: Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN.
     * 
     * @param trunks the trunks value to set.
     * @return the SipTrunkRoute object itself.
     */
    @Generated
    public SipTrunkRoute setTrunks(List<String> trunks) {
        this.trunks = trunks;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("numberPattern", this.numberPattern);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("trunks", this.trunks, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SipTrunkRoute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SipTrunkRoute if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SipTrunkRoute.
     */
    @Generated
    public static SipTrunkRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SipTrunkRoute deserializedSipTrunkRoute = new SipTrunkRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSipTrunkRoute.name = reader.getString();
                } else if ("numberPattern".equals(fieldName)) {
                    deserializedSipTrunkRoute.numberPattern = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSipTrunkRoute.description = reader.getString();
                } else if ("trunks".equals(fieldName)) {
                    List<String> trunks = reader.readArray(reader1 -> reader1.getString());
                    deserializedSipTrunkRoute.trunks = trunks;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSipTrunkRoute;
        });
    }
}
