// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a SIP trunk for routing calls. See RFC 4904.
 */
@Fluent
public final class SipTrunk implements JsonSerializable<SipTrunk> {
    /*
     * Gets or sets SIP signaling port of the trunk.
     */
    @Generated
    private int sipSignalingPort;

    /**
     * Creates an instance of SipTrunk class.
     */
    @Generated
    public SipTrunk() {
    }

    /**
     * Get the sipSignalingPort property: Gets or sets SIP signaling port of the trunk.
     * 
     * @return the sipSignalingPort value.
     */
    @Generated
    public int getSipSignalingPort() {
        return this.sipSignalingPort;
    }

    /**
     * Set the sipSignalingPort property: Gets or sets SIP signaling port of the trunk.
     * 
     * @param sipSignalingPort the sipSignalingPort value to set.
     * @return the SipTrunk object itself.
     */
    @Generated
    public SipTrunk setSipSignalingPort(int sipSignalingPort) {
        this.sipSignalingPort = sipSignalingPort;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("sipSignalingPort", this.sipSignalingPort);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SipTrunk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SipTrunk if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SipTrunk.
     */
    @Generated
    public static SipTrunk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SipTrunk deserializedSipTrunk = new SipTrunk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sipSignalingPort".equals(fieldName)) {
                    deserializedSipTrunk.sipSignalingPort = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSipTrunk;
        });
    }
}
