// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.communication.phonenumbers.siprouting.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Represents a SIP configuration.
 * When a call is being routed the routes are applied in the same order as in the routes list.
 * A route is matched by its number pattern.
 * Call is then directed into route's first available trunk, based on the order in the route's trunks list.
 */
@Fluent
public final class SipConfiguration implements JsonSerializable<SipConfiguration> {

    /*
     * SIP trunks for routing calls.
     * Map key is trunk's FQDN (1-249 characters).
     */
    @Generated
    private Map<String, SipTrunk> trunks;

    /*
     * Trunk routes for routing calls.
     */
    @Generated
    private List<SipTrunkRoute> routes;

    /**
     * Creates an instance of SipConfiguration class.
     */
    @Generated
    public SipConfiguration() {
    }

    /**
     * Get the trunks property: SIP trunks for routing calls.
     * Map key is trunk's FQDN (1-249 characters).
     *
     * @return the trunks value.
     */
    @Generated
    public Map<String, SipTrunk> getTrunks() {
        return this.trunks;
    }

    /**
     * Set the trunks property: SIP trunks for routing calls.
     * Map key is trunk's FQDN (1-249 characters).
     *
     * @param trunks the trunks value to set.
     * @return the SipConfiguration object itself.
     */
    @Generated
    public SipConfiguration setTrunks(Map<String, SipTrunk> trunks) {
        this.trunks = trunks;
        return this;
    }

    /**
     * Get the routes property: Trunk routes for routing calls.
     *
     * @return the routes value.
     */
    @Generated
    public List<SipTrunkRoute> getRoutes() {
        return this.routes;
    }

    /**
     * Set the routes property: Trunk routes for routing calls.
     *
     * @param routes the routes value to set.
     * @return the SipConfiguration object itself.
     */
    @Generated
    public SipConfiguration setRoutes(List<SipTrunkRoute> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("trunks", this.trunks, JsonWriter::writeJson, false);
        jsonWriter.writeArrayField("routes", this.routes, JsonWriter::writeJson, false);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SipConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SipConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SipConfiguration.
     */
    @Generated
    public static SipConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SipConfiguration deserializedSipConfiguration = new SipConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trunks".equals(fieldName)) {
                    Map<String, SipTrunk> trunks = reader.readMap(reader1 -> SipTrunk.fromJson(reader1));
                    deserializedSipConfiguration.trunks = trunks;
                } else if ("routes".equals(fieldName)) {
                    List<SipTrunkRoute> routes = reader.readArray(reader1 -> SipTrunkRoute.fromJson(reader1));
                    deserializedSipConfiguration.routes = routes;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSipConfiguration;
        });
    }
}
