// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Communication Services error.
 */
@Fluent
public final class CommunicationErrorResponse implements JsonSerializable<CommunicationErrorResponse> {
    /*
     * The Communication Services error.
     */
    @Generated
    private CommunicationError error;

    /**
     * Creates an instance of CommunicationErrorResponse class.
     */
    @Generated
    public CommunicationErrorResponse() {
    }

    /**
     * Get the error property: The Communication Services error.
     * 
     * @return the error value.
     */
    @Generated
    public CommunicationError getError() {
        return this.error;
    }

    /**
     * Set the error property: The Communication Services error.
     * 
     * @param error the error value to set.
     * @return the CommunicationErrorResponse object itself.
     */
    @Generated
    public CommunicationErrorResponse setError(CommunicationError error) {
        this.error = error;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommunicationErrorResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommunicationErrorResponse if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CommunicationErrorResponse.
     */
    @Generated
    public static CommunicationErrorResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommunicationErrorResponse deserializedCommunicationErrorResponse = new CommunicationErrorResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("error".equals(fieldName)) {
                    deserializedCommunicationErrorResponse.error = CommunicationError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommunicationErrorResponse;
        });
    }
}
