// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Represents a purchased phone number.
 */
@Immutable
public final class PurchasedPhoneNumber implements JsonSerializable<PurchasedPhoneNumber> {
    /*
     * The id of the phone number, e.g. 11234567890.
     */
    @Generated
    private String id;

    /*
     * String of the E.164 format of the phone number, e.g. +11234567890.
     */
    @Generated
    private String phoneNumber;

    /*
     * The ISO 3166-2 code of the phone number's country, e.g. US.
     */
    @Generated
    private String countryCode;

    /*
     * The phone number's type, e.g. geographic, tollFree, mobile.
     */
    @Generated
    private PhoneNumberType phoneNumberType;

    /*
     * Capabilities of a phone number.
     */
    @Generated
    private PhoneNumberCapabilities capabilities;

    /*
     * The assignment type of the phone number. A phone number can be assigned to a person, or to an application.
     */
    @Generated
    private PhoneNumberAssignmentType assignmentType;

    /*
     * The date and time that the phone number was purchased.
     */
    @Generated
    private OffsetDateTime purchaseDate;

    /*
     * The incurred cost for a single phone number.
     */
    @Generated
    private PhoneNumberCost cost;

    /**
     * Creates an instance of PurchasedPhoneNumber class.
     */
    @Generated
    public PurchasedPhoneNumber() {
    }

    /**
     * Get the id property: The id of the phone number, e.g. 11234567890.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the phoneNumber property: String of the E.164 format of the phone number, e.g. +11234567890.
     * 
     * @return the phoneNumber value.
     */
    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Get the countryCode property: The ISO 3166-2 code of the phone number's country, e.g. US.
     * 
     * @return the countryCode value.
     */
    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    /**
     * Get the phoneNumberType property: The phone number's type, e.g. geographic, tollFree, mobile.
     * 
     * @return the phoneNumberType value.
     */
    @Generated
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     * 
     * @return the capabilities value.
     */
    @Generated
    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Get the assignmentType property: The assignment type of the phone number. A phone number can be assigned to a
     * person, or to an application.
     * 
     * @return the assignmentType value.
     */
    @Generated
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Get the purchaseDate property: The date and time that the phone number was purchased.
     * 
     * @return the purchaseDate value.
     */
    @Generated
    public OffsetDateTime getPurchaseDate() {
        return this.purchaseDate;
    }

    /**
     * Get the cost property: The incurred cost for a single phone number.
     * 
     * @return the cost value.
     */
    @Generated
    public PhoneNumberCost getCost() {
        return this.cost;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PurchasedPhoneNumber from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PurchasedPhoneNumber if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PurchasedPhoneNumber.
     */
    @Generated
    public static PurchasedPhoneNumber fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PurchasedPhoneNumber deserializedPurchasedPhoneNumber = new PurchasedPhoneNumber();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.id = reader.getString();
                } else if ("phoneNumber".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.phoneNumber = reader.getString();
                } else if ("countryCode".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.countryCode = reader.getString();
                } else if ("phoneNumberType".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                } else if ("capabilities".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.capabilities = PhoneNumberCapabilities.fromJson(reader);
                } else if ("assignmentType".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.assignmentType
                        = PhoneNumberAssignmentType.fromString(reader.getString());
                } else if ("purchaseDate".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.purchaseDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("cost".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.cost = PhoneNumberCost.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPurchasedPhoneNumber;
        });
    }
}
