// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.implementation.accesshelpers.PhoneNumbersReservationAccessHelper;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

/**
 * Represents a reservation for phone numbers. A reservation is a temporary hold on phone numbers that can later be
 * purchased. The reservation has a limited lifetime after which the phone numbers are released if not purchased.
 * Reservations older than 1 month are automatically deleted.
 */
@Immutable
public final class PhoneNumbersReservation implements JsonSerializable<PhoneNumbersReservation> {

    static {
        PhoneNumbersReservationAccessHelper
            .setAccessor(new PhoneNumbersReservationAccessHelper.PhoneNumbersReservationAccessor() {

                @Override
                public void setPhoneNumbers(PhoneNumbersReservation reservation,
                    Map<String, AvailablePhoneNumber> phoneNumbers) {
                    reservation.setPhoneNumbers(phoneNumbers);
                }
            });
    }

    /*
     * The id of the reservation.
     */
    @Generated
    private UUID id;

    /*
     * The time at which the reservation will expire. If a reservation is not purchased before this time, all of the
     * reserved phone numbers will be released and made available for others to purchase.
     */
    @Generated
    private OffsetDateTime expiresAt;

    /*
     * A dictionary containing the reservation phone numbers. The key is the ID of the phone number (digits only) and
     * values are AvailablePhoneNumber objects. Not populated when retrieving PhoneNumbersReservation collections.
     */
    @Generated
    private Map<String, AvailablePhoneNumber> phoneNumbers;

    /*
     * Represents the status of the reservation. Possible values include: 'active', 'submitted', 'completed', 'expired'.
     */
    @Generated
    private PhoneNumbersReservationStatus status;

    /**
     * Creates an instance of PhoneNumbersReservation class.
     */
    @Generated
    public PhoneNumbersReservation() {
    }

    /**
     * Get the expiresAt property: The time at which the reservation will expire. If a reservation is not purchased
     * before this time, all of the reserved phone numbers will be released and made available for others to purchase.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    /**
     * Get the phoneNumbers property: A dictionary containing the reservation phone numbers. The key is the ID of the
     * phone number (digits only) and values are AvailablePhoneNumber objects. Not populated when retrieving
     * PhoneNumbersReservation collections.
     *
     * @return the phoneNumbers value.
     */
    @Generated
    public Map<String, AvailablePhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Get the status property: Represents the status of the reservation. Possible values include: 'active',
     * 'submitted', 'completed', 'expired'.
     *
     * @return the status value.
     */
    @Generated
    public PhoneNumbersReservationStatus getStatus() {
        return this.status;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.id != null) {
            jsonWriter.writeStringField("id", this.id.toString());
        }
        if (this.expiresAt != null) {
            jsonWriter.writeStringField("expiresAt", this.expiresAt.toString());
        }
        if (this.phoneNumbers != null) {
            jsonWriter.writeMapField("phoneNumbers", this.phoneNumbers, (writer, value) -> {
                if (value != null) {
                    value.toJson(writer);
                } else {
                    writer.writeNull();
                }
            });
        }
        if (this.status != null) {
            jsonWriter.writeStringField("status", this.status.toString());
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumbersReservation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumbersReservation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumbersReservation.
     */
    @Generated
    public static PhoneNumbersReservation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumbersReservation deserializedPhoneNumbersReservation = new PhoneNumbersReservation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.id
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("expiresAt".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.expiresAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("phoneNumbers".equals(fieldName)) {
                    Map<String, AvailablePhoneNumber> phoneNumbers
                        = reader.readMap(reader1 -> AvailablePhoneNumber.fromJson(reader1));
                    deserializedPhoneNumbersReservation.phoneNumbers = phoneNumbers;
                } else if ("status".equals(fieldName)) {
                    deserializedPhoneNumbersReservation.status
                        = PhoneNumbersReservationStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedPhoneNumbersReservation;
        });
    }

    /**
     * Set the phoneNumbers property: The phone numbers in the reservation.
     *
     * @param phoneNumbers the phone numbers in the reservation.
     * @return the PhoneNumbersReservation object itself.
     */
    private PhoneNumbersReservation setPhoneNumbers(Map<String, AvailablePhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Get the id property: The id of the reservation.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id.toString();
    }
}
