// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The result of a phone number browse operation.
 */
@Immutable
public final class PhoneNumbersBrowseResult implements JsonSerializable<PhoneNumbersBrowseResult> {
    /*
     * The phone numbers that are available for purchase.
     */
    @Generated
    private List<AvailablePhoneNumber> phoneNumbers;

    /**
     * Creates an instance of PhoneNumbersBrowseResult class.
     */
    @Generated
    public PhoneNumbersBrowseResult() {
    }

    /**
     * Get the phoneNumbers property: The phone numbers that are available for purchase.
     * 
     * @return the phoneNumbers value.
     */
    @Generated
    public List<AvailablePhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumbersBrowseResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumbersBrowseResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumbersBrowseResult.
     */
    @Generated
    public static PhoneNumbersBrowseResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumbersBrowseResult deserializedPhoneNumbersBrowseResult = new PhoneNumbersBrowseResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumbers".equals(fieldName)) {
                    List<AvailablePhoneNumber> phoneNumbers
                        = reader.readArray(reader1 -> AvailablePhoneNumber.fromJson(reader1));
                    deserializedPhoneNumbersBrowseResult.phoneNumbers = phoneNumbers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumbersBrowseResult;
        });
    }
}
