// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of operation, e.g. Search.
 */
public final class PhoneNumberOperationType extends ExpandableStringEnum<PhoneNumberOperationType> {
    /**
     * Static value purchase for PhoneNumberOperationType.
     */
    @Generated
    public static final PhoneNumberOperationType PURCHASE = fromString("purchase");

    /**
     * Static value releasePhoneNumber for PhoneNumberOperationType.
     */
    @Generated
    public static final PhoneNumberOperationType RELEASE_PHONE_NUMBER = fromString("releasePhoneNumber");

    /**
     * Static value search for PhoneNumberOperationType.
     */
    @Generated
    public static final PhoneNumberOperationType SEARCH = fromString("search");

    /**
     * Static value updatePhoneNumberCapabilities for PhoneNumberOperationType.
     */
    @Generated
    public static final PhoneNumberOperationType UPDATE_PHONE_NUMBER_CAPABILITIES
        = fromString("updatePhoneNumberCapabilities");

    /**
     * Static value reservationPurchase for PhoneNumberOperationType.
     */
    @Generated
    public static final PhoneNumberOperationType RESERVATION_PURCHASE = fromString("reservationPurchase");

    /**
     * Creates a new instance of PhoneNumberOperationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public PhoneNumberOperationType() {
    }

    /**
     * Creates or finds a PhoneNumberOperationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PhoneNumberOperationType.
     */
    @Generated
    public static PhoneNumberOperationType fromString(String name) {
        return fromString(name, PhoneNumberOperationType.class);
    }

    /**
     * Gets known PhoneNumberOperationType values.
     * 
     * @return known PhoneNumberOperationType values.
     */
    @Generated
    public static Collection<PhoneNumberOperationType> values() {
        return values(PhoneNumberOperationType.class);
    }
}
