// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;
import java.time.OffsetDateTime;

/** The PhoneNumberOperation model. */
@Immutable
public final class PhoneNumberOperation implements JsonSerializable<PhoneNumberOperation> {
    /*
     * Status of operation.
     */
    private final PhoneNumberOperationStatus status;

    /*
     * URL for retrieving the result of the operation, if any.
     */
    private final String resourceLocation;

    /*
     * The date that the operation was created.
     */
    private final OffsetDateTime createdDateTime;

    /*
     * Id of operation.
     */
    private final String id;

    /*
     * The type of operation, e.g. Search
     */
    private final PhoneNumberOperationType operationType;

    /*
     * The most recent date that the operation was changed.
     */
    private final OffsetDateTime lastActionDateTime;

    /**
     * The PhoneNumberOperation model.
     * @param status The status property: Status of operation.
     * @param resourceLocation The resourceLocation property: URL for retrieving the result of the operation, if any.
     * @param createdDateTime The createdDateTime property: The date that the operation was created.
     * @param id The id property: Id of operation.
     * @param operationType The operationType property: The type of operation, e.g. Search.
     * @param lastActionDateTime The lastActionDateTime property: The most recent date that the operation was changed.
     */
    public PhoneNumberOperation(PhoneNumberOperationStatus status, String resourceLocation,
        OffsetDateTime createdDateTime, String id, PhoneNumberOperationType operationType,
        OffsetDateTime lastActionDateTime) {
        this.status = status;
        this.resourceLocation = resourceLocation;
        this.createdDateTime = createdDateTime;
        this.id = id;
        this.operationType = operationType;
        this.lastActionDateTime = lastActionDateTime;
    }

    /**
     * Get the status property: Status of operation.
     *
     * @return the status value.
     */
    public PhoneNumberOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the resourceLocation property: URL for retrieving the result of the operation, if any.
     *
     * @return the resourceLocation value.
     */
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Get the createdDateTime property: The date that the operation was created.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the id property: Id of operation.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the operationType property: The type of operation, e.g. Search.
     *
     * @return the operationType value.
     */
    public PhoneNumberOperationType getOperationType() {
        return this.operationType;
    }

    /**
     * Get the lastActionDateTime property: The most recent date that the operation was changed.
     *
     * @return the lastActionDateTime value.
     */
    public OffsetDateTime getLastActionDateTime() {
        return this.lastActionDateTime;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeEndObject();
    }

    /**
     * Reads an instance of {@link PhoneNumberOperation} from the {@code jsonReader}.
     *
     * @param jsonReader The {@link JsonReader} to read from.
     * @return An instance of {@link PhoneNumberOperation}, or null if pointing to {@link JsonToken#NULL}.
     * @throws IOException If an error occurs while reading the {@link JsonReader}.
     */
    public static PhoneNumberOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberOperationStatus status = null;
            String resourceLocation = null;
            OffsetDateTime createdDateTime = null;
            String id = null;
            PhoneNumberOperationType operationType = null;
            OffsetDateTime lastActionDateTime = null;

            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    status = PhoneNumberOperationStatus.fromString(reader.getString());
                } else if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = CoreUtils.parseBestOffsetDateTime(reader.getString());
                } else if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("operationType".equals(fieldName)) {
                    operationType = PhoneNumberOperationType.fromString(reader.getString());
                } else if ("lastActionDateTime".equals(fieldName)) {
                    lastActionDateTime = CoreUtils.parseBestOffsetDateTime(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return new PhoneNumberOperation(status, resourceLocation, createdDateTime, id, operationType,
                lastActionDateTime);
        });
    }
}
