// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a locality.
 */
@Immutable
public final class PhoneNumberLocality implements JsonSerializable<PhoneNumberLocality> {
    /*
     * Represents the localized name of the locality.
     */
    @Generated
    private String localizedName;

    /*
     * Represents an administrative division. e.g. state or province.
     */
    @Generated
    private PhoneNumberAdministrativeDivision administrativeDivision;

    /**
     * Creates an instance of PhoneNumberLocality class.
     */
    @Generated
    public PhoneNumberLocality() {
    }

    /**
     * Get the localizedName property: Represents the localized name of the locality.
     * 
     * @return the localizedName value.
     */
    @Generated
    public String getLocalizedName() {
        return this.localizedName;
    }

    /**
     * Get the administrativeDivision property: Represents an administrative division. e.g. state or province.
     * 
     * @return the administrativeDivision value.
     */
    @Generated
    public PhoneNumberAdministrativeDivision getAdministrativeDivision() {
        return this.administrativeDivision;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberLocality from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberLocality if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumberLocality.
     */
    @Generated
    public static PhoneNumberLocality fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberLocality deserializedPhoneNumberLocality = new PhoneNumberLocality();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localizedName".equals(fieldName)) {
                    deserializedPhoneNumberLocality.localizedName = reader.getString();
                } else if ("administrativeDivision".equals(fieldName)) {
                    deserializedPhoneNumberLocality.administrativeDivision
                        = PhoneNumberAdministrativeDivision.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberLocality;
        });
    }
}
