// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The incurred cost for a single phone number.
 */
@Immutable
public final class PhoneNumberCost implements JsonSerializable<PhoneNumberCost> {

    /*
     * The cost amount.
     */
    @Generated
    private double amount;

    /*
     * The ISO 4217 currency code for the cost amount, e.g. USD.
     */
    @Generated
    private String currencyCode;

    /*
     * The frequency with which the cost gets billed.
     */
    @Generated
    private BillingFrequency billingFrequency;

    /**
     * Creates an instance of PhoneNumberCost class.
     */
    @Generated
    public PhoneNumberCost() {
    }

    /**
     * Get the amount property: The cost amount.
     *
     * @return the amount value.
     */
    @Generated
    public double getAmount() {
        return this.amount;
    }

    /**
     * Get the currencyCode property: The ISO 4217 currency code for the cost amount, e.g. USD.
     *
     * @return the currencyCode value.
     */
    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    /**
     * Get the billingFrequency property: The frequency with which the cost gets billed.
     *
     * @return the billingFrequency value.
     */
    @Generated
    public BillingFrequency getBillingFrequency() {
        return this.billingFrequency;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("amount", this.amount);
        if (this.currencyCode != null) {
            jsonWriter.writeStringField("currencyCode", this.currencyCode);
        }
        if (this.billingFrequency != null) {
            jsonWriter.writeStringField("billingFrequency", this.billingFrequency.toString());
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberCost from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberCost if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumberCost.
     */
    @Generated
    public static PhoneNumberCost fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberCost deserializedPhoneNumberCost = new PhoneNumberCost();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("amount".equals(fieldName)) {
                    deserializedPhoneNumberCost.amount = reader.getDouble();
                } else if ("currencyCode".equals(fieldName)) {
                    deserializedPhoneNumberCost.currencyCode = reader.getString();
                } else if ("billingFrequency".equals(fieldName)) {
                    deserializedPhoneNumberCost.billingFrequency = BillingFrequency.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedPhoneNumberCost;
        });
    }
}
