// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents the status of the phone number. Possible values include: 'available', 'reserved', 'expired', 'error',
 * 'purchased'.
 */
public final class PhoneNumberAvailabilityStatus extends ExpandableStringEnum<PhoneNumberAvailabilityStatus> {
    /**
     * Static value available for PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static final PhoneNumberAvailabilityStatus AVAILABLE = fromString("available");

    /**
     * Static value reserved for PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static final PhoneNumberAvailabilityStatus RESERVED = fromString("reserved");

    /**
     * Static value expired for PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static final PhoneNumberAvailabilityStatus EXPIRED = fromString("expired");

    /**
     * Static value error for PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static final PhoneNumberAvailabilityStatus ERROR = fromString("error");

    /**
     * Static value purchased for PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static final PhoneNumberAvailabilityStatus PURCHASED = fromString("purchased");

    /**
     * Creates a new instance of PhoneNumberAvailabilityStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public PhoneNumberAvailabilityStatus() {
    }

    /**
     * Creates or finds a PhoneNumberAvailabilityStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PhoneNumberAvailabilityStatus.
     */
    @Generated
    public static PhoneNumberAvailabilityStatus fromString(String name) {
        return fromString(name, PhoneNumberAvailabilityStatus.class);
    }

    /**
     * Gets known PhoneNumberAvailabilityStatus values.
     * 
     * @return known PhoneNumberAvailabilityStatus values.
     */
    @Generated
    public static Collection<PhoneNumberAvailabilityStatus> values() {
        return values(PhoneNumberAvailabilityStatus.class);
    }
}
