// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an Area Code.
 */
@Immutable
public final class PhoneNumberAreaCode implements JsonSerializable<PhoneNumberAreaCode> {
    /*
     * An area code.
     */
    @Generated
    private String areaCode;

    /**
     * Creates an instance of PhoneNumberAreaCode class.
     */
    @Generated
    public PhoneNumberAreaCode() {
    }

    /**
     * Get the areaCode property: An area code.
     * 
     * @return the areaCode value.
     */
    @Generated
    public String getAreaCode() {
        return this.areaCode;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberAreaCode from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberAreaCode if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumberAreaCode.
     */
    @Generated
    public static PhoneNumberAreaCode fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberAreaCode deserializedPhoneNumberAreaCode = new PhoneNumberAreaCode();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("areaCode".equals(fieldName)) {
                    deserializedPhoneNumberAreaCode.areaCode = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberAreaCode;
        });
    }
}
