// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an administrative division. e.g. state or province.
 */
@Immutable
public final class PhoneNumberAdministrativeDivision implements JsonSerializable<PhoneNumberAdministrativeDivision> {
    /*
     * Represents the localized name of the administrative division of the locality. e.g. state or province localized
     * name.
     */
    @Generated
    private String localizedName;

    /*
     * Represents the abbreviated name of the administrative division of the locality. e.g. state or province
     * abbreviation such as WA (Washington).
     */
    @Generated
    private String abbreviatedName;

    /**
     * Creates an instance of PhoneNumberAdministrativeDivision class.
     */
    @Generated
    public PhoneNumberAdministrativeDivision() {
    }

    /**
     * Get the localizedName property: Represents the localized name of the administrative division of the locality.
     * e.g. state or province localized name.
     * 
     * @return the localizedName value.
     */
    @Generated
    public String getLocalizedName() {
        return this.localizedName;
    }

    /**
     * Get the abbreviatedName property: Represents the abbreviated name of the administrative division of the locality.
     * e.g. state or province abbreviation such as WA (Washington).
     * 
     * @return the abbreviatedName value.
     */
    @Generated
    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberAdministrativeDivision from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberAdministrativeDivision if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumberAdministrativeDivision.
     */
    @Generated
    public static PhoneNumberAdministrativeDivision fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberAdministrativeDivision deserializedPhoneNumberAdministrativeDivision
                = new PhoneNumberAdministrativeDivision();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localizedName".equals(fieldName)) {
                    deserializedPhoneNumberAdministrativeDivision.localizedName = reader.getString();
                } else if ("abbreviatedName".equals(fieldName)) {
                    deserializedPhoneNumberAdministrativeDivision.abbreviatedName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberAdministrativeDivision;
        });
    }
}
