// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a search result containing format and operator information associated with the requested phone numbers.
 */
@Immutable
public final class OperatorInformationResult implements JsonSerializable<OperatorInformationResult> {
    /*
     * Results of a search.
     * This array will have one entry per requested phone number which will contain the relevant operator information.
     */
    @Generated
    private List<OperatorInformation> values;

    /**
     * Creates an instance of OperatorInformationResult class.
     */
    @Generated
    public OperatorInformationResult() {
    }

    /**
     * Get the values property: Results of a search.
     * This array will have one entry per requested phone number which will contain the relevant operator information.
     * 
     * @return the values value.
     */
    @Generated
    public List<OperatorInformation> getValues() {
        return this.values;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperatorInformationResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperatorInformationResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperatorInformationResult.
     */
    @Generated
    public static OperatorInformationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorInformationResult deserializedOperatorInformationResult = new OperatorInformationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("values".equals(fieldName)) {
                    List<OperatorInformation> values
                        = reader.readArray(reader1 -> OperatorInformation.fromJson(reader1));
                    deserializedOperatorInformationResult.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperatorInformationResult;
        });
    }
}
