// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents options to modify a search request for operator information.
 */
@Fluent
public final class OperatorInformationOptions implements JsonSerializable<OperatorInformationOptions> {
    /*
     * Includes the fields operatorDetails, numberType, and isoCountryCode in the response. Please note: use of this
     * option will result in additional costs
     */
    @Generated
    private Boolean includeAdditionalOperatorDetails;

    /**
     * Creates an instance of OperatorInformationOptions class.
     */
    @Generated
    public OperatorInformationOptions() {
    }

    /**
     * Get the includeAdditionalOperatorDetails property: Includes the fields operatorDetails, numberType, and
     * isoCountryCode in the response. Please note: use of this option will result in additional costs.
     * 
     * @return the includeAdditionalOperatorDetails value.
     */
    @Generated
    public Boolean isIncludeAdditionalOperatorDetails() {
        return this.includeAdditionalOperatorDetails;
    }

    /**
     * Set the includeAdditionalOperatorDetails property: Includes the fields operatorDetails, numberType, and
     * isoCountryCode in the response. Please note: use of this option will result in additional costs.
     * 
     * @param includeAdditionalOperatorDetails the includeAdditionalOperatorDetails value to set.
     * @return the OperatorInformationOptions object itself.
     */
    @Generated
    public OperatorInformationOptions setIncludeAdditionalOperatorDetails(Boolean includeAdditionalOperatorDetails) {
        this.includeAdditionalOperatorDetails = includeAdditionalOperatorDetails;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("includeAdditionalOperatorDetails", this.includeAdditionalOperatorDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperatorInformationOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperatorInformationOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperatorInformationOptions.
     */
    @Generated
    public static OperatorInformationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorInformationOptions deserializedOperatorInformationOptions = new OperatorInformationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("includeAdditionalOperatorDetails".equals(fieldName)) {
                    deserializedOperatorInformationOptions.includeAdditionalOperatorDetails
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperatorInformationOptions;
        });
    }
}
