// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents metadata describing the operator of a phone number.
 */
@Immutable
public final class OperatorDetails implements JsonSerializable<OperatorDetails> {
    /*
     * Name of the phone operator
     */
    @Generated
    private String name;

    /*
     * Mobile Network Code, 2 or 3 decimal digits that identify mobile networks within a country/region
     */
    @Generated
    private String mobileNetworkCode;

    /*
     * Mobile Country Code, 3 decimal digits that identify a country/region
     */
    @Generated
    private String mobileCountryCode;

    /**
     * Creates an instance of OperatorDetails class.
     */
    @Generated
    public OperatorDetails() {
    }

    /**
     * Get the name property: Name of the phone operator.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the mobileNetworkCode property: Mobile Network Code, 2 or 3 decimal digits that identify mobile networks
     * within a country/region.
     * 
     * @return the mobileNetworkCode value.
     */
    @Generated
    public String getMobileNetworkCode() {
        return this.mobileNetworkCode;
    }

    /**
     * Get the mobileCountryCode property: Mobile Country Code, 3 decimal digits that identify a country/region.
     * 
     * @return the mobileCountryCode value.
     */
    @Generated
    public String getMobileCountryCode() {
        return this.mobileCountryCode;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperatorDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperatorDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperatorDetails.
     */
    @Generated
    public static OperatorDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorDetails deserializedOperatorDetails = new OperatorDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOperatorDetails.name = reader.getString();
                } else if ("mobileNetworkCode".equals(fieldName)) {
                    deserializedOperatorDetails.mobileNetworkCode = reader.getString();
                } else if ("mobileCountryCode".equals(fieldName)) {
                    deserializedOperatorDetails.mobileCountryCode = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperatorDetails;
        });
    }
}
