// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The parameters for the browse operation.
 */
@Fluent
public final class BrowsePhoneNumbersOptions implements JsonSerializable<BrowsePhoneNumbersOptions> {

    /*
     * Represents the number type of the offering.
     */
    @Generated
    private PhoneNumberType phoneNumberType;

    /*
     * Capabilities of a phone number.
     */
    @Generated
    private PhoneNumberCapabilities capabilities;

    /*
     * Represents the assignment type of the offering. Also known as the use case.
     */
    @Generated
    private PhoneNumberAssignmentType assignmentType;

    /*
     * The phone number prefix to match. If specified, the search will be limited to phone numbers that start with the
     * any of the given prefixes.
     */
    @Generated
    private List<String> phoneNumberPrefixes;

    /*
     * The ISO 3166-2 country code, e.g. US.
     */
    @Generated
    private String countryCode;

    /**
     * Get the phoneNumberType property: Represents the number type of the offering.
     *
     * @return the phoneNumberType value.
     */
    @Generated
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     *
     * @return the capabilities value.
     */
    @Generated
    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: Capabilities of a phone number.
     *
     * @param capabilities the capabilities value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    @Generated
    public BrowsePhoneNumbersOptions setCapabilities(PhoneNumberCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the assignmentType property: Represents the assignment type of the offering. Also known as the use case.
     *
     * @return the assignmentType value.
     */
    @Generated
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Set the assignmentType property: Represents the assignment type of the offering. Also known as the use case.
     *
     * @param assignmentType the assignmentType value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    @Generated
    public BrowsePhoneNumbersOptions setAssignmentType(PhoneNumberAssignmentType assignmentType) {
        this.assignmentType = assignmentType;
        return this;
    }

    /**
     * Get the phoneNumberPrefixes property: The phone number prefix to match. If specified, the search will be limited
     * to phone numbers that start with the any of the given prefixes.
     *
     * @return the phoneNumberPrefixes value.
     */
    @Generated
    public List<String> getPhoneNumberPrefixes() {
        return this.phoneNumberPrefixes;
    }

    /**
     * Set the phoneNumberPrefixes property: The phone number prefix to match. If specified, the search will be limited
     * to phone numbers that start with the any of the given prefixes.
     *
     * @param phoneNumberPrefixes the phoneNumberPrefixes value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    @Generated
    public BrowsePhoneNumbersOptions setPhoneNumberPrefixes(List<String> phoneNumberPrefixes) {
        this.phoneNumberPrefixes = phoneNumberPrefixes;
        return this;
    }

    /**
     * Get the countryCode property: The ISO 3166-2 country code, e.g. US.
     *
     * @return the countryCode value.
     */
    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("phoneNumberType",
            this.phoneNumberType == null ? null : this.phoneNumberType.toString());
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeStringField("assignmentType",
            this.assignmentType == null ? null : this.assignmentType.toString());
        jsonWriter.writeArrayField("phoneNumberPrefixes", this.phoneNumberPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("countryCode", this.countryCode);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BrowsePhoneNumbersOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BrowsePhoneNumbersOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BrowsePhoneNumbersOptions.
     */
    @Generated
    public static BrowsePhoneNumbersOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BrowsePhoneNumbersOptions deserializedBrowsePhoneNumbersOptions = new BrowsePhoneNumbersOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("phoneNumberType".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.phoneNumberType
                        = PhoneNumberType.fromString(reader.getString());
                } else if ("capabilities".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.capabilities = PhoneNumberCapabilities.fromJson(reader);
                } else if ("assignmentType".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.assignmentType
                        = PhoneNumberAssignmentType.fromString(reader.getString());
                } else if ("phoneNumberPrefixes".equals(fieldName)) {
                    List<String> phoneNumberPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBrowsePhoneNumbersOptions.phoneNumberPrefixes = phoneNumberPrefixes;
                } else if ("countryCode".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.countryCode = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedBrowsePhoneNumbersOptions;
        });
    }

    private BrowsePhoneNumbersOptions() {
    }

    /**
     * Creates an instance of BrowsePhoneNumbersOptions with required parameters.
     *
     * @param countryCode The ISO 3166-2 country code, e.g., US.
     * @param phoneNumberType The type of phone number.
     */
    public BrowsePhoneNumbersOptions(String countryCode, PhoneNumberType phoneNumberType) {
        this.countryCode = countryCode;
        this.phoneNumberType = phoneNumberType;
    }
}
