// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a phone number available in inventory.
 */
@Immutable
public final class AvailablePhoneNumber implements JsonSerializable<AvailablePhoneNumber> {

    /*
     * The id of the phone number.
     */
    @Generated
    private String id;

    /*
     * The ISO 3166-2 country code, e.g. US.
     */
    @Generated
    private String countryCode;

    /*
     * The phone number in E.164 format, e.g. +11234567890.
     */
    @Generated
    private String phoneNumber;

    /*
     * Capabilities of a phone number.
     */
    @Generated
    private PhoneNumberCapabilities capabilities;

    /*
     * Represents the number type of the offering.
     */
    @Generated
    private PhoneNumberType phoneNumberType;

    /*
     * Represents the assignment type of the offering. Also known as the use case.
     */
    @Generated
    private PhoneNumberAssignmentType assignmentType;

    /*
     * The incurred cost for this phone number.
     */
    @Generated
    private PhoneNumberCost cost;

    /*
     * Represents the status of the phone number. Possible values include: 'available', 'reserved', 'expired', 'error',
     * 'purchased'.
     */
    @Generated
    private PhoneNumberAvailabilityStatus status;

    /*
     * Indicates if do not resell agreement is required. If true, the phone number cannot be acquired unless the
     * customer provides explicit agreement to not resell it.
     */
    @Generated
    private Boolean isAgreementToNotResellRequired;

    /*
     * Contains error details in case of failure when reserving, releasing or purchasing the phone number. Note that
     * this is ignored by the service when present in requests.
     */
    @Generated
    private ResponseError error;

    /**
     * Creates an instance of AvailablePhoneNumber class.
     */
    @Generated
    public AvailablePhoneNumber() {
    }

    /**
     * Get the id property: The id of the phone number.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the countryCode property: The ISO 3166-2 country code, e.g. US.
     *
     * @return the countryCode value.
     */
    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    /**
     * Get the phoneNumber property: The phone number in E.164 format, e.g. +11234567890.
     *
     * @return the phoneNumber value.
     */
    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     *
     * @return the capabilities value.
     */
    @Generated
    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Get the phoneNumberType property: Represents the number type of the offering.
     *
     * @return the phoneNumberType value.
     */
    @Generated
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the assignmentType property: Represents the assignment type of the offering. Also known as the use case.
     *
     * @return the assignmentType value.
     */
    @Generated
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Get the cost property: The incurred cost for this phone number.
     *
     * @return the cost value.
     */
    @Generated
    public PhoneNumberCost getCost() {
        return this.cost;
    }

    /**
     * Get the status property: Represents the status of the phone number. Possible values include: 'available',
     * 'reserved', 'expired', 'error', 'purchased'.
     *
     * @return the status value.
     */
    @Generated
    public PhoneNumberAvailabilityStatus getStatus() {
        return this.status;
    }

    /**
     * Get the isAgreementToNotResellRequired property: Indicates if do not resell agreement is required. If true, the
     * phone number cannot be acquired unless the customer provides explicit agreement to not resell it.
     *
     * @return the isAgreementToNotResellRequired value.
     */
    @Generated
    public Boolean isAgreementToNotResellRequired() {
        return this.isAgreementToNotResellRequired;
    }

    /**
     * Get the error property: The error object.
     *
     * @return the error value.
     */
    @Generated
    public ResponseError getError() {
        return this.error;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.countryCode != null) {
            jsonWriter.writeStringField("countryCode", this.countryCode);
        }
        if (this.capabilities != null) {
            jsonWriter.writeFieldName("capabilities");
            this.capabilities.toJson(jsonWriter);
        }
        if (this.phoneNumberType != null) {
            jsonWriter.writeStringField("phoneNumberType", this.phoneNumberType.toString());
        }
        if (this.assignmentType != null) {
            jsonWriter.writeStringField("assignmentType", this.assignmentType.toString());
        }
        if (this.id != null) {
            jsonWriter.writeStringField("id", this.id);
        }
        if (this.phoneNumber != null) {
            jsonWriter.writeStringField("phoneNumber", this.phoneNumber);
        }
        if (this.cost != null) {
            jsonWriter.writeFieldName("cost");
            this.cost.toJson(jsonWriter);
        }
        if (this.status != null) {
            jsonWriter.writeStringField("status", this.status.toString());
        }
        if (this.isAgreementToNotResellRequired != null) {
            jsonWriter.writeBooleanField("isAgreementToNotResellRequired", this.isAgreementToNotResellRequired);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailablePhoneNumber from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailablePhoneNumber if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AvailablePhoneNumber.
     */
    @Generated
    public static AvailablePhoneNumber fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailablePhoneNumber deserializedAvailablePhoneNumber = new AvailablePhoneNumber();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("countryCode".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.countryCode = reader.getString();
                } else if ("capabilities".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.capabilities = PhoneNumberCapabilities.fromJson(reader);
                } else if ("phoneNumberType".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                } else if ("assignmentType".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.assignmentType
                        = PhoneNumberAssignmentType.fromString(reader.getString());
                } else if ("id".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.id = reader.getString();
                } else if ("phoneNumber".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.phoneNumber = reader.getString();
                } else if ("cost".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.cost = PhoneNumberCost.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.status
                        = PhoneNumberAvailabilityStatus.fromString(reader.getString());
                } else if ("isAgreementToNotResellRequired".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.isAgreementToNotResellRequired
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("error".equals(fieldName)) {
                    deserializedAvailablePhoneNumber.error = ResponseError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAvailablePhoneNumber;
        });
    }
}
