// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of purchased phone numbers.
 */
@Fluent
public final class PurchasedPhoneNumbers implements JsonSerializable<PurchasedPhoneNumbers> {
    /*
     * Represents a list of phone numbers.
     */
    @Generated
    private List<PurchasedPhoneNumber> phoneNumbers;

    /*
     * Represents the URL link to the next page of phone number results.
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of PurchasedPhoneNumbers class.
     */
    @Generated
    public PurchasedPhoneNumbers() {
    }

    /**
     * Get the phoneNumbers property: Represents a list of phone numbers.
     * 
     * @return the phoneNumbers value.
     */
    @Generated
    public List<PurchasedPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Set the phoneNumbers property: Represents a list of phone numbers.
     * 
     * @param phoneNumbers the phoneNumbers value to set.
     * @return the PurchasedPhoneNumbers object itself.
     */
    @Generated
    public PurchasedPhoneNumbers setPhoneNumbers(List<PurchasedPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page of phone number results.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Represents the URL link to the next page of phone number results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PurchasedPhoneNumbers object itself.
     */
    @Generated
    public PurchasedPhoneNumbers setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PurchasedPhoneNumbers from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PurchasedPhoneNumbers if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PurchasedPhoneNumbers.
     */
    @Generated
    public static PurchasedPhoneNumbers fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PurchasedPhoneNumbers deserializedPurchasedPhoneNumbers = new PurchasedPhoneNumbers();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumbers".equals(fieldName)) {
                    List<PurchasedPhoneNumber> phoneNumbers
                        = reader.readArray(reader1 -> PurchasedPhoneNumber.fromJson(reader1));
                    deserializedPurchasedPhoneNumbers.phoneNumbers = phoneNumbers;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPurchasedPhoneNumbers.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPurchasedPhoneNumbers;
        });
    }
}
