// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumbersReservation;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a list of phone numbers reservations. Note that the phone numbers from each reservation are not included.
 */
@Fluent
public final class PhoneNumbersReservations implements JsonSerializable<PhoneNumbersReservations> {
    /*
     * Represents a list of phone numbers reservations. Note that the phone numbers from each reservation are not
     * included.
     */
    @Generated
    private List<PhoneNumbersReservation> reservations;

    /*
     * Represents the URL link to the next page of phone number results.
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of PhoneNumbersReservations class.
     */
    @Generated
    public PhoneNumbersReservations() {
    }

    /**
     * Get the reservations property: Represents a list of phone numbers reservations. Note that the phone numbers from
     * each reservation are not included.
     * 
     * @return the reservations value.
     */
    @Generated
    public List<PhoneNumbersReservation> getReservations() {
        return this.reservations;
    }

    /**
     * Set the reservations property: Represents a list of phone numbers reservations. Note that the phone numbers from
     * each reservation are not included.
     * 
     * @param reservations the reservations value to set.
     * @return the PhoneNumbersReservations object itself.
     */
    @Generated
    public PhoneNumbersReservations setReservations(List<PhoneNumbersReservation> reservations) {
        this.reservations = reservations;
        return this;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page of phone number results.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Represents the URL link to the next page of phone number results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PhoneNumbersReservations object itself.
     */
    @Generated
    public PhoneNumbersReservations setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("reservations", this.reservations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumbersReservations from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumbersReservations if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumbersReservations.
     */
    @Generated
    public static PhoneNumbersReservations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumbersReservations deserializedPhoneNumbersReservations = new PhoneNumbersReservations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("reservations".equals(fieldName)) {
                    List<PhoneNumbersReservation> reservations
                        = reader.readArray(reader1 -> PhoneNumbersReservation.fromJson(reader1));
                    deserializedPhoneNumbersReservations.reservations = reservations;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPhoneNumbersReservations.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumbersReservations;
        });
    }
}
