// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The phone number search purchase request.
 */
@Fluent
public final class PhoneNumbersReservationPurchaseRequest
    implements JsonSerializable<PhoneNumbersReservationPurchaseRequest> {
    /*
     * The agreement to not resell the phone numbers. Defaults to false if not provided.
     */
    @Generated
    private Boolean agreeToNotResell;

    /**
     * Creates an instance of PhoneNumbersReservationPurchaseRequest class.
     */
    @Generated
    public PhoneNumbersReservationPurchaseRequest() {
    }

    /**
     * Get the agreeToNotResell property: The agreement to not resell the phone numbers. Defaults to false if not
     * provided.
     * 
     * @return the agreeToNotResell value.
     */
    @Generated
    public Boolean isAgreeToNotResell() {
        return this.agreeToNotResell;
    }

    /**
     * Set the agreeToNotResell property: The agreement to not resell the phone numbers. Defaults to false if not
     * provided.
     * 
     * @param agreeToNotResell the agreeToNotResell value to set.
     * @return the PhoneNumbersReservationPurchaseRequest object itself.
     */
    @Generated
    public PhoneNumbersReservationPurchaseRequest setAgreeToNotResell(Boolean agreeToNotResell) {
        this.agreeToNotResell = agreeToNotResell;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("agreeToNotResell", this.agreeToNotResell);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumbersReservationPurchaseRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumbersReservationPurchaseRequest if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumbersReservationPurchaseRequest.
     */
    @Generated
    public static PhoneNumbersReservationPurchaseRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumbersReservationPurchaseRequest deserializedPhoneNumbersReservationPurchaseRequest
                = new PhoneNumbersReservationPurchaseRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("agreeToNotResell".equals(fieldName)) {
                    deserializedPhoneNumbersReservationPurchaseRequest.agreeToNotResell
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumbersReservationPurchaseRequest;
        });
    }
}
