// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/**
 * The PhoneNumbersPurchaseReservationHeaders model.
 */
@Fluent
public final class PhoneNumbersPurchaseReservationHeaders {
    /*
     * The operation-id property.
     */
    @Generated
    private String operationId;

    /*
     * The reservation-purchase-id property.
     */
    @Generated
    private String reservationPurchaseId;

    /*
     * The Operation-Location property.
     */
    @Generated
    private String operationLocation;

    private static final HttpHeaderName OPERATION_ID = HttpHeaderName.fromString("operation-id");

    private static final HttpHeaderName RESERVATION_PURCHASE_ID = HttpHeaderName.fromString("reservation-purchase-id");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of PhoneNumbersPurchaseReservationHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public PhoneNumbersPurchaseReservationHeaders(HttpHeaders rawHeaders) {
        this.operationId = rawHeaders.getValue(OPERATION_ID);
        this.reservationPurchaseId = rawHeaders.getValue(RESERVATION_PURCHASE_ID);
        this.operationLocation = rawHeaders.getValue(HttpHeaderName.OPERATION_LOCATION);
    }

    /**
     * Get the operationId property: The operation-id property.
     * 
     * @return the operationId value.
     */
    @Generated
    public String getOperationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: The operation-id property.
     * 
     * @param operationId the operationId value to set.
     * @return the PhoneNumbersPurchaseReservationHeaders object itself.
     */
    @Generated
    public PhoneNumbersPurchaseReservationHeaders setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the reservationPurchaseId property: The reservation-purchase-id property.
     * 
     * @return the reservationPurchaseId value.
     */
    @Generated
    public String getReservationPurchaseId() {
        return this.reservationPurchaseId;
    }

    /**
     * Set the reservationPurchaseId property: The reservation-purchase-id property.
     * 
     * @param reservationPurchaseId the reservationPurchaseId value to set.
     * @return the PhoneNumbersPurchaseReservationHeaders object itself.
     */
    @Generated
    public PhoneNumbersPurchaseReservationHeaders setReservationPurchaseId(String reservationPurchaseId) {
        this.reservationPurchaseId = reservationPurchaseId;
        return this;
    }

    /**
     * Get the operationLocation property: The Operation-Location property.
     * 
     * @return the operationLocation value.
     */
    @Generated
    public String getOperationLocation() {
        return this.operationLocation;
    }

    /**
     * Set the operationLocation property: The Operation-Location property.
     * 
     * @param operationLocation the operationLocation value to set.
     * @return the PhoneNumbersPurchaseReservationHeaders object itself.
     */
    @Generated
    public PhoneNumbersPurchaseReservationHeaders setOperationLocation(String operationLocation) {
        this.operationLocation = operationLocation;
        return this;
    }
}
