// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a wrapper around a list of cities or towns.
 */
@Immutable
public final class PhoneNumberLocalities implements JsonSerializable<PhoneNumberLocalities> {
    /*
     * Represents the underlying list of localities, e.g. cities or town.
     */
    @Generated
    private List<PhoneNumberLocality> phoneNumberLocalities;

    /*
     * Represents the URL link to the next page.
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of PhoneNumberLocalities class.
     */
    @Generated
    public PhoneNumberLocalities() {
    }

    /**
     * Get the phoneNumberLocalities property: Represents the underlying list of localities, e.g. cities or town.
     * 
     * @return the phoneNumberLocalities value.
     */
    @Generated
    public List<PhoneNumberLocality> getPhoneNumberLocalities() {
        return this.phoneNumberLocalities;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberLocalities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberLocalities if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumberLocalities.
     */
    @Generated
    public static PhoneNumberLocalities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberLocalities deserializedPhoneNumberLocalities = new PhoneNumberLocalities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumberLocalities".equals(fieldName)) {
                    List<PhoneNumberLocality> phoneNumberLocalities
                        = reader.readArray(reader1 -> PhoneNumberLocality.fromJson(reader1));
                    deserializedPhoneNumberLocalities.phoneNumberLocalities = phoneNumberLocalities;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPhoneNumberLocalities.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberLocalities;
        });
    }
}
