// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a wrapper around a list of countries.
 */
@Immutable
public final class PhoneNumberCountries implements JsonSerializable<PhoneNumberCountries> {
    /*
     * Represents the underlying list of countries.
     */
    @Generated
    private List<PhoneNumberCountry> countries;

    /*
     * Represents the URL link to the next page
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of PhoneNumberCountries class.
     */
    @Generated
    public PhoneNumberCountries() {
    }

    /**
     * Get the countries property: Represents the underlying list of countries.
     * 
     * @return the countries value.
     */
    @Generated
    public List<PhoneNumberCountry> getCountries() {
        return this.countries;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberCountries from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberCountries if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumberCountries.
     */
    @Generated
    public static PhoneNumberCountries fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberCountries deserializedPhoneNumberCountries = new PhoneNumberCountries();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("countries".equals(fieldName)) {
                    List<PhoneNumberCountry> countries
                        = reader.readArray(reader1 -> PhoneNumberCountry.fromJson(reader1));
                    deserializedPhoneNumberCountries.countries = countries;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPhoneNumberCountries.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberCountries;
        });
    }
}
