// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberCapabilityType;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Capabilities of a phone number.
 */
@Fluent
public final class PhoneNumberCapabilitiesRequest implements JsonSerializable<PhoneNumberCapabilitiesRequest> {
    /*
     * Capability value for calling.
     */
    @Generated
    private PhoneNumberCapabilityType calling;

    /*
     * Capability value for SMS.
     */
    @Generated
    private PhoneNumberCapabilityType sms;

    /**
     * Creates an instance of PhoneNumberCapabilitiesRequest class.
     */
    @Generated
    public PhoneNumberCapabilitiesRequest() {
    }

    /**
     * Get the calling property: Capability value for calling.
     * 
     * @return the calling value.
     */
    @Generated
    public PhoneNumberCapabilityType getCalling() {
        return this.calling;
    }

    /**
     * Set the calling property: Capability value for calling.
     * 
     * @param calling the calling value to set.
     * @return the PhoneNumberCapabilitiesRequest object itself.
     */
    @Generated
    public PhoneNumberCapabilitiesRequest setCalling(PhoneNumberCapabilityType calling) {
        this.calling = calling;
        return this;
    }

    /**
     * Get the sms property: Capability value for SMS.
     * 
     * @return the sms value.
     */
    @Generated
    public PhoneNumberCapabilityType getSms() {
        return this.sms;
    }

    /**
     * Set the sms property: Capability value for SMS.
     * 
     * @param sms the sms value to set.
     * @return the PhoneNumberCapabilitiesRequest object itself.
     */
    @Generated
    public PhoneNumberCapabilitiesRequest setSms(PhoneNumberCapabilityType sms) {
        this.sms = sms;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("calling", this.calling == null ? null : this.calling.toString());
        jsonWriter.writeStringField("sms", this.sms == null ? null : this.sms.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberCapabilitiesRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberCapabilitiesRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumberCapabilitiesRequest.
     */
    @Generated
    public static PhoneNumberCapabilitiesRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberCapabilitiesRequest deserializedPhoneNumberCapabilitiesRequest
                = new PhoneNumberCapabilitiesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("calling".equals(fieldName)) {
                    deserializedPhoneNumberCapabilitiesRequest.calling
                        = PhoneNumberCapabilityType.fromString(reader.getString());
                } else if ("sms".equals(fieldName)) {
                    deserializedPhoneNumberCapabilitiesRequest.sms
                        = PhoneNumberCapabilityType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberCapabilitiesRequest;
        });
    }
}
