// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberCapabilityType;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The minimum desired capabilities for the browse operation request.
 */
@Fluent
public final class PhoneNumberBrowseCapabilitiesRequest
    implements JsonSerializable<PhoneNumberBrowseCapabilitiesRequest> {
    /*
     * Capability value for calling.
     */
    @Generated
    private PhoneNumberCapabilityType calling;

    /*
     * Capability value for SMS.
     */
    @Generated
    private PhoneNumberCapabilityType sms;

    /**
     * Creates an instance of PhoneNumberBrowseCapabilitiesRequest class.
     */
    @Generated
    public PhoneNumberBrowseCapabilitiesRequest() {
    }

    /**
     * Get the calling property: Capability value for calling.
     * 
     * @return the calling value.
     */
    @Generated
    public PhoneNumberCapabilityType getCalling() {
        return this.calling;
    }

    /**
     * Set the calling property: Capability value for calling.
     * 
     * @param calling the calling value to set.
     * @return the PhoneNumberBrowseCapabilitiesRequest object itself.
     */
    @Generated
    public PhoneNumberBrowseCapabilitiesRequest setCalling(PhoneNumberCapabilityType calling) {
        this.calling = calling;
        return this;
    }

    /**
     * Get the sms property: Capability value for SMS.
     * 
     * @return the sms value.
     */
    @Generated
    public PhoneNumberCapabilityType getSms() {
        return this.sms;
    }

    /**
     * Set the sms property: Capability value for SMS.
     * 
     * @param sms the sms value to set.
     * @return the PhoneNumberBrowseCapabilitiesRequest object itself.
     */
    @Generated
    public PhoneNumberBrowseCapabilitiesRequest setSms(PhoneNumberCapabilityType sms) {
        this.sms = sms;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("calling", this.calling == null ? null : this.calling.toString());
        jsonWriter.writeStringField("sms", this.sms == null ? null : this.sms.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberBrowseCapabilitiesRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberBrowseCapabilitiesRequest if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PhoneNumberBrowseCapabilitiesRequest.
     */
    @Generated
    public static PhoneNumberBrowseCapabilitiesRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberBrowseCapabilitiesRequest deserializedPhoneNumberBrowseCapabilitiesRequest
                = new PhoneNumberBrowseCapabilitiesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("calling".equals(fieldName)) {
                    deserializedPhoneNumberBrowseCapabilitiesRequest.calling
                        = PhoneNumberCapabilityType.fromString(reader.getString());
                } else if ("sms".equals(fieldName)) {
                    deserializedPhoneNumberBrowseCapabilitiesRequest.sms
                        = PhoneNumberCapabilityType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberBrowseCapabilitiesRequest;
        });
    }
}
