// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of available area codes.
 */
@Immutable
public final class PhoneNumberAreaCodes implements JsonSerializable<PhoneNumberAreaCodes> {
    /*
     * Represents a list of available toll-free area codes.
     */
    @Generated
    private List<PhoneNumberAreaCode> areaCodes;

    /*
     * Represents the URL link to the next page.
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of PhoneNumberAreaCodes class.
     */
    @Generated
    public PhoneNumberAreaCodes() {
    }

    /**
     * Get the areaCodes property: Represents a list of available toll-free area codes.
     * 
     * @return the areaCodes value.
     */
    @Generated
    public List<PhoneNumberAreaCode> getAreaCodes() {
        return this.areaCodes;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberAreaCodes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberAreaCodes if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumberAreaCodes.
     */
    @Generated
    public static PhoneNumberAreaCodes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberAreaCodes deserializedPhoneNumberAreaCodes = new PhoneNumberAreaCodes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("areaCodes".equals(fieldName)) {
                    List<PhoneNumberAreaCode> areaCodes
                        = reader.readArray(reader1 -> PhoneNumberAreaCode.fromJson(reader1));
                    deserializedPhoneNumberAreaCodes.areaCodes = areaCodes;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPhoneNumberAreaCodes.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberAreaCodes;
        });
    }
}
