// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.OperatorInformation;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;
import java.util.List;

/**
 * Represents a search result containing format and operator information associated with the requested phone numbers.
 */
@Immutable
public final class OperatorInformationResult implements JsonSerializable<OperatorInformationResult> {
    /*
     * Results of a search.
     * This array will have one entry per requested phone number which will
     * contain the relevant operator information.
     */
    private List<OperatorInformation> values;

    /**
     * Get the values property: Results of a search. This array will have one entry per requested phone number which
     * will contain the relevant operator information.
     *
     * @return the values value.
     */
    public List<OperatorInformation> getValues() {
        return this.values;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeEndObject();
    }

    /**
     * Reads an instance of {@link OperatorInformationResult} from the {@code jsonReader}.
     *
     * @param jsonReader The {@link JsonReader} to read from.
     * @return An instance of {@link OperatorInformationResult}, or null if pointing to {@link JsonToken#NULL}.
     * @throws IOException If an error occurs while reading the {@link JsonReader}.
     */
    public static OperatorInformationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorInformationResult result = new OperatorInformationResult();

            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("values".equals(fieldName)) {
                    result.values = reader.readArray(OperatorInformation::fromJson);
                } else {
                    reader.skipChildren();
                }
            }

            return result;
        });
    }
}
