// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;

import java.io.IOException;

/** Represents options to modify a search request for operator information. */
@Fluent
public final class OperatorInformationRequestOptions implements JsonSerializable<OperatorInformationRequestOptions> {
    /*
     * Includes the fields operatorDetails, numberType, and isoCountryCode in
     * the response.  Please note: use of this option will result in additional
     * costs
     */
    private Boolean includeAdditionalPhoneAndOperatorDetails;

    /**
     * Get the includeAdditionalPhoneAndOperatorDetails property: Includes the fields operatorDetails, numberType, and
     * isoCountryCode in the response. Please note: use of this option will result in additional costs.
     *
     * @return the includeAdditionalPhoneAndOperatorDetails value.
     */
    public Boolean isIncludeAdditionalPhoneAndOperatorDetails() {
        return this.includeAdditionalPhoneAndOperatorDetails;
    }

    /**
     * Set the includeAdditionalPhoneAndOperatorDetails property: Includes the fields operatorDetails, numberType, and
     * isoCountryCode in the response. Please note: use of this option will result in additional costs.
     *
     * @param includeAdditionalPhoneAndOperatorDetails the includeAdditionalPhoneAndOperatorDetails value to set.
     * @return the OperatorInformationRequestOptions object itself.
     */
    public OperatorInformationRequestOptions
        setIncludeAdditionalPhoneAndOperatorDetails(Boolean includeAdditionalPhoneAndOperatorDetails) {
        this.includeAdditionalPhoneAndOperatorDetails = includeAdditionalPhoneAndOperatorDetails;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject()
            .writeBooleanField("includeAdditionalPhoneAndOperatorDetails", includeAdditionalPhoneAndOperatorDetails)
            .writeEndObject();
    }

    /**
     * Reads an instance of {@link OperatorInformationRequestOptions} from the {@code jsonReader}.
     *
     * @param jsonReader The {@link JsonReader} to read from.
     * @return An instance of {@link OperatorInformationRequestOptions}, or null if pointing to {@link JsonToken#NULL}.
     * @throws IOException If an error occurs while reading the {@link JsonReader}.
     */
    public static OperatorInformationRequestOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorInformationRequestOptions options = new OperatorInformationRequestOptions();

            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("includeAdditionalPhoneAndOperatorDetails".equals(fieldName)) {
                    options.includeAdditionalPhoneAndOperatorDetails = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return options;
        });
    }
}
