// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.OperatorInformationOptions;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a search request for operator information for the given phone numbers.
 */
@Fluent
public final class OperatorInformationRequest implements JsonSerializable<OperatorInformationRequest> {
    /*
     * Phone number(s) whose operator information is being requested
     */
    @Generated
    private List<String> phoneNumbers;

    /*
     * Represents options to modify a search request for operator information
     */
    @Generated
    private OperatorInformationOptions options;

    /**
     * Creates an instance of OperatorInformationRequest class.
     */
    @Generated
    public OperatorInformationRequest() {
    }

    /**
     * Get the phoneNumbers property: Phone number(s) whose operator information is being requested.
     * 
     * @return the phoneNumbers value.
     */
    @Generated
    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Set the phoneNumbers property: Phone number(s) whose operator information is being requested.
     * 
     * @param phoneNumbers the phoneNumbers value to set.
     * @return the OperatorInformationRequest object itself.
     */
    @Generated
    public OperatorInformationRequest setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Get the options property: Represents options to modify a search request for operator information.
     * 
     * @return the options value.
     */
    @Generated
    public OperatorInformationOptions getOptions() {
        return this.options;
    }

    /**
     * Set the options property: Represents options to modify a search request for operator information.
     * 
     * @param options the options value to set.
     * @return the OperatorInformationRequest object itself.
     */
    @Generated
    public OperatorInformationRequest setOptions(OperatorInformationOptions options) {
        this.options = options;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperatorInformationRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperatorInformationRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OperatorInformationRequest.
     */
    @Generated
    public static OperatorInformationRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperatorInformationRequest deserializedOperatorInformationRequest = new OperatorInformationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumbers".equals(fieldName)) {
                    List<String> phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    deserializedOperatorInformationRequest.phoneNumbers = phoneNumbers;
                } else if ("options".equals(fieldName)) {
                    deserializedOperatorInformationRequest.options = OperatorInformationOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperatorInformationRequest;
        });
    }
}
