// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a wrapper around a list of offerings.
 */
@Immutable
public final class OfferingsResponse implements JsonSerializable<OfferingsResponse> {
    /*
     * Represents the underlying list of offerings.
     */
    @Generated
    private List<PhoneNumberOffering> phoneNumberOfferings;

    /*
     * Represents the URL link to the next page.
     */
    @Generated
    private String nextLink;

    /**
     * Creates an instance of OfferingsResponse class.
     */
    @Generated
    public OfferingsResponse() {
    }

    /**
     * Get the phoneNumberOfferings property: Represents the underlying list of offerings.
     * 
     * @return the phoneNumberOfferings value.
     */
    @Generated
    public List<PhoneNumberOffering> getPhoneNumberOfferings() {
        return this.phoneNumberOfferings;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page.
     * 
     * @return the nextLink value.
     */
    @Generated
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OfferingsResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OfferingsResponse if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OfferingsResponse.
     */
    @Generated
    public static OfferingsResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OfferingsResponse deserializedOfferingsResponse = new OfferingsResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumberOfferings".equals(fieldName)) {
                    List<PhoneNumberOffering> phoneNumberOfferings
                        = reader.readArray(reader1 -> PhoneNumberOffering.fromJson(reader1));
                    deserializedOfferingsResponse.phoneNumberOfferings = phoneNumberOfferings;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedOfferingsResponse.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOfferingsResponse;
        });
    }
}
