// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The parameters for the browse operation.
 */
@Fluent
public final class BrowsePhoneNumbersOptions implements JsonSerializable<BrowsePhoneNumbersOptions> {
    /*
     * Represents the number type of the offering.
     */
    private PhoneNumberType phoneNumberType;

    /*
     * Capabilities of a phone number.
     */
    private PhoneNumberCapabilitiesRequest capabilities;

    /*
     * Represents the assignment type of the offering. Also known as the use case.
     */
    private PhoneNumberAssignmentType assignmentType;

    /*
     * The phone number prefix to match. If specified, the search will be limited to phone numbers that start with the any of the given prefixes.
     */
    private List<String> phoneNumberPrefixes;

    /**
     * Creates an instance of BrowsePhoneNumbersOptions class.
     */
    public BrowsePhoneNumbersOptions() {
    }

    /**
     * Get the phoneNumberType property: Represents the number type of the offering.
     * 
     * @return the phoneNumberType value.
     */
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Set the phoneNumberType property: Represents the number type of the offering.
     * 
     * @param phoneNumberType the phoneNumberType value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    public BrowsePhoneNumbersOptions setPhoneNumberType(PhoneNumberType phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
        return this;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     * 
     * @return the capabilities value.
     */
    public PhoneNumberCapabilitiesRequest getCapabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: Capabilities of a phone number.
     * 
     * @param capabilities the capabilities value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    public BrowsePhoneNumbersOptions setCapabilities(PhoneNumberCapabilitiesRequest capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the assignmentType property: Represents the assignment type of the offering. Also known as the use case.
     * 
     * @return the assignmentType value.
     */
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Set the assignmentType property: Represents the assignment type of the offering. Also known as the use case.
     * 
     * @param assignmentType the assignmentType value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    public BrowsePhoneNumbersOptions setAssignmentType(PhoneNumberAssignmentType assignmentType) {
        this.assignmentType = assignmentType;
        return this;
    }

    /**
     * Get the phoneNumberPrefixes property: The phone number prefix to match. If specified, the search will be limited
     * to phone numbers that start with the any of the given prefixes.
     * 
     * @return the phoneNumberPrefixes value.
     */
    public List<String> getPhoneNumberPrefixes() {
        return this.phoneNumberPrefixes;
    }

    /**
     * Set the phoneNumberPrefixes property: The phone number prefix to match. If specified, the search will be limited
     * to phone numbers that start with the any of the given prefixes.
     * 
     * @param phoneNumberPrefixes the phoneNumberPrefixes value to set.
     * @return the BrowsePhoneNumbersOptions object itself.
     */
    public BrowsePhoneNumbersOptions setPhoneNumberPrefixes(List<String> phoneNumberPrefixes) {
        this.phoneNumberPrefixes = phoneNumberPrefixes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("phoneNumberType",
            this.phoneNumberType == null ? null : this.phoneNumberType.toString());
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeStringField("assignmentType",
            this.assignmentType == null ? null : this.assignmentType.toString());
        jsonWriter.writeArrayField("phoneNumberPrefixes", this.phoneNumberPrefixes,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BrowsePhoneNumbersOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BrowsePhoneNumbersOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BrowsePhoneNumbersOptions.
     */
    public static BrowsePhoneNumbersOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BrowsePhoneNumbersOptions deserializedBrowsePhoneNumbersOptions = new BrowsePhoneNumbersOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("phoneNumberType".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.phoneNumberType
                        = PhoneNumberType.fromString(reader.getString());
                } else if ("capabilities".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.capabilities
                        = PhoneNumberCapabilitiesRequest.fromJson(reader);
                } else if ("assignmentType".equals(fieldName)) {
                    deserializedBrowsePhoneNumbersOptions.assignmentType
                        = PhoneNumberAssignmentType.fromString(reader.getString());
                } else if ("phoneNumberPrefixes".equals(fieldName)) {
                    List<String> phoneNumberPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBrowsePhoneNumbersOptions.phoneNumberPrefixes = phoneNumberPrefixes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBrowsePhoneNumbersOptions;
        });
    }
}
