// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains error details in case of failure when reserving, releasing or purchasing the phone number. Note that this is
 * ignored by the service when present in requests.
 */
@Immutable
public final class AvailablePhoneNumberError implements JsonSerializable<AvailablePhoneNumberError> {
    /*
     * The error code indicating the reason why the operation performed on the phone number failed.
     */
    @Generated
    private String code;

    /*
     * The error message describing the failure that occurred.
     */
    @Generated
    private String message;

    /**
     * Creates an instance of AvailablePhoneNumberError class.
     */
    @Generated
    public AvailablePhoneNumberError() {
    }

    /**
     * Get the code property: The error code indicating the reason why the operation performed on the phone number
     * failed.
     * 
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: The error message describing the failure that occurred.
     * 
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailablePhoneNumberError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailablePhoneNumberError if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailablePhoneNumberError.
     */
    @Generated
    public static AvailablePhoneNumberError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailablePhoneNumberError deserializedAvailablePhoneNumberError = new AvailablePhoneNumberError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedAvailablePhoneNumberError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedAvailablePhoneNumberError.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailablePhoneNumberError;
        });
    }
}
