// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation;

import com.azure.communication.phonenumbers.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.implementation.models.OfferingsResponse;
import com.azure.communication.phonenumbers.implementation.models.OperatorInformationRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberAreaCodes;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCapabilitiesRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCountries;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberLocalities;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberRawOperation;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberSearchRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersGetOperationHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchasePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchaseReservationHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReleasePhoneNumberHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReservationPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReservations;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersSearchAvailablePhoneNumbersHeaders;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersUpdateCapabilitiesHeaders;
import com.azure.communication.phonenumbers.implementation.models.PurchasedPhoneNumbers;
import com.azure.communication.phonenumbers.models.BrowsePhoneNumbersOptions;
import com.azure.communication.phonenumbers.models.OperatorInformationResult;
import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PhoneNumbersBrowseResult;
import com.azure.communication.phonenumbers.models.PhoneNumbersReservation;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PhoneNumbers.
 */
public final class PhoneNumbersImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PhoneNumbersService service;

    /**
     * The service client containing this operation class.
     */
    private final PhoneNumberAdminClientImpl client;

    /**
     * Initializes an instance of PhoneNumbersImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    PhoneNumbersImpl(PhoneNumberAdminClientImpl client) {
        this.service
            = RestProxy.create(PhoneNumbersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PhoneNumberAdminClientPhoneNumbers to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "PhoneNumberAdminClientPhoneNumbers")
    public interface PhoneNumbersService {
        @Get("/availablePhoneNumbers/countries/{countryCode}/areaCodes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberAreaCodes>> listAreaCodes(@HostParam("endpoint") String endpoint,
            @PathParam("countryCode") String countryCode,
            @QueryParam("phoneNumberType") PhoneNumberType phoneNumberType, @QueryParam("skip") Integer skip,
            @QueryParam("maxPageSize") Integer maxPageSize,
            @QueryParam("assignmentType") PhoneNumberAssignmentType assignmentType,
            @QueryParam("locality") String locality,
            @QueryParam("administrativeDivision") String administrativeDivision,
            @QueryParam("api-version") String apiVersion, @HeaderParam("accept-language") String acceptLanguage,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/availablePhoneNumbers/countries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberCountries>> listAvailableCountries(@HostParam("endpoint") String endpoint,
            @QueryParam("skip") Integer skip, @QueryParam("maxPageSize") Integer maxPageSize,
            @QueryParam("api-version") String apiVersion, @HeaderParam("accept-language") String acceptLanguage,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/availablePhoneNumbers/countries/{countryCode}/:browse")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbers(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("countryCode") String countryCode,
            @BodyParam("application/json") BrowsePhoneNumbersOptions phoneNumbersBrowseRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/availablePhoneNumbers/countries/{countryCode}/localities")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberLocalities>> listAvailableLocalities(@HostParam("endpoint") String endpoint,
            @PathParam("countryCode") String countryCode, @QueryParam("skip") Integer skip,
            @QueryParam("maxPageSize") Integer maxPageSize,
            @QueryParam("administrativeDivision") String administrativeDivision,
            @QueryParam("api-version") String apiVersion, @HeaderParam("accept-language") String acceptLanguage,
            @QueryParam("phoneNumberType") PhoneNumberType phoneNumberType, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/availablePhoneNumbers/countries/{countryCode}/offerings")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<OfferingsResponse>> listOfferings(@HostParam("endpoint") String endpoint,
            @PathParam("countryCode") String countryCode, @QueryParam("skip") Integer skip,
            @QueryParam("maxPageSize") Integer maxPageSize,
            @QueryParam("phoneNumberType") PhoneNumberType phoneNumberType,
            @QueryParam("assignmentType") PhoneNumberAssignmentType assignmentType,
            @QueryParam("api-version") String apiVersion, @HeaderParam("accept-language") String acceptLanguage,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/availablePhoneNumbers/reservations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumbersReservations>> listReservations(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @QueryParam("maxPageSize") Integer maxPageSize,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses({ 200, 201, 207 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumbersReservation>> createOrUpdateReservation(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("reservationId") UUID reservationId,
            @BodyParam("application/merge-patch+json") PhoneNumbersReservation reservation,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumbersReservation>> getReservation(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("reservationId") UUID reservationId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/availablePhoneNumbers/reservations/{reservationId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> deleteReservation(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("reservationId") UUID reservationId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/availablePhoneNumbers/reservations/{reservationId}/:purchase")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservation(
            @HostParam("endpoint") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("reservationId") UUID reservationId,
            @BodyParam("application/json") PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/availablePhoneNumbers/reservations/{reservationId}/:purchase")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> purchaseReservationNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("reservationId") UUID reservationId,
            @BodyParam("application/json") PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>>
            searchAvailablePhoneNumbers(@HostParam("endpoint") String endpoint,
                @PathParam("countryCode") String countryCode, @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") PhoneNumberSearchRequest body, @HeaderParam("Accept") String accept,
                Context context);

        @Post("/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberSearchResult>> searchAvailablePhoneNumbersNoCustomHeaders(
            @HostParam("endpoint") String endpoint, @PathParam("countryCode") String countryCode,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") PhoneNumberSearchRequest body,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/availablePhoneNumbers/searchResults/{searchId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberSearchResult>> getSearchResult(@HostParam("endpoint") String endpoint,
            @PathParam("searchId") String searchId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/availablePhoneNumbers/:purchase")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>> purchasePhoneNumbers(
            @HostParam("endpoint") String endpoint, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PhoneNumberPurchaseRequest body, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/availablePhoneNumbers/:purchase")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> purchasePhoneNumbersNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PhoneNumberPurchaseRequest body, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/phoneNumbers/operations/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>> getOperation(
            @HostParam("endpoint") String endpoint, @PathParam("operationId") String operationId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/phoneNumbers/operations/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("operationId") String operationId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/phoneNumbers/operations/{operationId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> cancelOperation(@HostParam("endpoint") String endpoint,
            @PathParam("operationId") String operationId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>> updateCapabilities(
            @HostParam("endpoint") String endpoint, @PathParam("phoneNumber") String phoneNumber,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/merge-patch+json") PhoneNumberCapabilitiesRequest body,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("phoneNumber") String phoneNumber, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/merge-patch+json") PhoneNumberCapabilitiesRequest body,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/phoneNumbers/{phoneNumber}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PurchasedPhoneNumber>> getByNumber(@HostParam("endpoint") String endpoint,
            @PathParam("phoneNumber") String phoneNumber, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/phoneNumbers/{phoneNumber}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>> releasePhoneNumber(
            @HostParam("endpoint") String endpoint, @PathParam("phoneNumber") String phoneNumber,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Delete("/phoneNumbers/{phoneNumber}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> releasePhoneNumberNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("phoneNumber") String phoneNumber, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/phoneNumbers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbers(@HostParam("endpoint") String endpoint,
            @QueryParam("skip") Integer skip, @QueryParam("top") Integer top,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/operatorInformation/:search")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<OperatorInformationResult>> operatorInformationSearch(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") OperatorInformationRequest body, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberAreaCodes>> listAreaCodesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("accept-language") String acceptLanguage, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberCountries>> listAvailableCountriesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("accept-language") String acceptLanguage, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumberLocalities>> listAvailableLocalitiesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("accept-language") String acceptLanguage, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<OfferingsResponse>> listOfferingsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("accept-language") String acceptLanguage, @HeaderParam("Accept") String accept,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PhoneNumbersReservations>> listReservationsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode,
        PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType,
        String locality, String administrativeDivision, String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip,
                maxPageSize, assignmentType, locality, administrativeDivision, this.client.getApiVersion(),
                acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAreaCodes(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode,
        PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType,
        String locality, String administrativeDivision, String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service
            .listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip, maxPageSize, assignmentType,
                locality, administrativeDivision, this.client.getApiVersion(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAreaCodes(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType,
        Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality,
        String administrativeDivision, String acceptLanguage) {
        return new PagedFlux<>(
            () -> listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType,
                locality, administrativeDivision, acceptLanguage),
            nextLink -> listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage));
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType,
        Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality,
        String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedFlux<>(
            () -> listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType,
                locality, administrativeDivision, acceptLanguage, context),
            nextLink -> listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage, context));
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesSinglePage(String countryCode,
        PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType,
        String locality, String administrativeDivision, String acceptLanguage) {
        return listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality,
            administrativeDivision, acceptLanguage).block();
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesSinglePage(String countryCode,
        PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType,
        String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality,
            administrativeDivision, acceptLanguage, context).block();
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType,
        Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality,
        String administrativeDivision, String acceptLanguage) {
        return new PagedIterable<>(listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType,
            locality, administrativeDivision, acceptLanguage));
    }

    /**
     * Gets the list of available area codes.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param locality The name of locality or town in which to search for the area code. This is required if the number
     * type is Geographic.
     * @param administrativeDivision The name of the state or province in which to search for the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType,
        Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality,
        String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedIterable<>(listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType,
            locality, administrativeDivision, acceptLanguage, context));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip,
        Integer maxPageSize, String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize,
                this.client.getApiVersion(), acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getCountries(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip,
        Integer maxPageSize, String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service
            .listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize, this.client.getApiVersion(),
                acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getCountries(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize,
        String acceptLanguage) {
        return new PagedFlux<>(() -> listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage),
            nextLink -> listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize,
        String acceptLanguage, Context context) {
        return new PagedFlux<>(() -> listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage, context),
            nextLink -> listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage, context));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesSinglePage(Integer skip, Integer maxPageSize,
        String acceptLanguage) {
        return listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage).block();
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesSinglePage(Integer skip, Integer maxPageSize,
        String acceptLanguage, Context context) {
        return listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage, context).block();
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize,
        String acceptLanguage) {
        return new PagedIterable<>(listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage));
    }

    /**
     * Gets the list of supported countries.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of supported countries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize,
        String acceptLanguage, Context context) {
        return new PagedIterable<>(listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage, context));
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbersWithResponseAsync(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return FluxUtil.withContext(
            context -> browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, context));
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersBrowseResult>> browseAvailableNumbersWithResponseAsync(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        final String accept = "application/json";
        return service.browseAvailableNumbers(this.client.getEndpoint(), this.client.getApiVersion(), countryCode,
            phoneNumbersBrowseRequest, accept, context);
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersBrowseResult> browseAvailableNumbersAsync(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersBrowseResult> browseAvailableNumbersAsync(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        return browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumbersBrowseResult> browseAvailableNumbersWithResponse(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest, Context context) {
        return browseAvailableNumbersWithResponseAsync(countryCode, phoneNumbersBrowseRequest, context).block();
    }

    /**
     * Browses for available phone numbers to purchase.
     * 
     * Browses for available phone numbers to purchase. The response will be a randomized list of phone numbers
     * available to purchase matching the browsing criteria. This operation is not paginated. Since the results are
     * randomized, repeating the same request will not guarantee the same results.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param phoneNumbersBrowseRequest An object defining the criteria to browse for available phone numbers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number browse operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumbersBrowseResult browseAvailableNumbers(String countryCode,
        BrowsePhoneNumbersOptions phoneNumbersBrowseRequest) {
        return browseAvailableNumbersWithResponse(countryCode, phoneNumbersBrowseRequest, Context.NONE).getValue();
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode,
        Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage,
        PhoneNumberType phoneNumberType) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableLocalities(this.client.getEndpoint(), countryCode, skip,
                maxPageSize, administrativeDivision, this.client.getApiVersion(), acceptLanguage, phoneNumberType,
                accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberLocalities(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode,
        Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage,
        PhoneNumberType phoneNumberType, Context context) {
        final String accept = "application/json";
        return service
            .listAvailableLocalities(this.client.getEndpoint(), countryCode, skip, maxPageSize, administrativeDivision,
                this.client.getApiVersion(), acceptLanguage, phoneNumberType, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberLocalities(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType) {
        return new PagedFlux<>(
            () -> listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision,
                acceptLanguage, phoneNumberType),
            nextLink -> listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage));
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType,
        Context context) {
        return new PagedFlux<>(
            () -> listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision,
                acceptLanguage, phoneNumberType, context),
            nextLink -> listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage, context));
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesSinglePage(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType) {
        return listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision,
            acceptLanguage, phoneNumberType).block();
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesSinglePage(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType,
        Context context) {
        return listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision,
            acceptLanguage, phoneNumberType, context).block();
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType) {
        return new PagedIterable<>(listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision,
            acceptLanguage, phoneNumberType));
    }

    /**
     * Gets the list of cities or towns with available phone numbers.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param administrativeDivision An optional parameter for the name of the state or province in which to search for
     * the area code.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of cities or towns with available phone numbers as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip,
        Integer maxPageSize, String administrativeDivision, String acceptLanguage, PhoneNumberType phoneNumberType,
        Context context) {
        return new PagedIterable<>(listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision,
            acceptLanguage, phoneNumberType, context));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip,
        Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType,
        String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize,
                phoneNumberType, assignmentType, this.client.getApiVersion(), acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberOfferings(), res.getValue().getNextLink(), null));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip,
        Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType,
        String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service
            .listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize, phoneNumberType, assignmentType,
                this.client.getApiVersion(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberOfferings(), res.getValue().getNextLink(), null));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize,
        PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedFlux<>(() -> listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType,
            assignmentType, acceptLanguage), nextLink -> listOfferingsNextSinglePageAsync(nextLink, acceptLanguage));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize,
        PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage,
        Context context) {
        return new PagedFlux<>(
            () -> listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType,
                acceptLanguage, context),
            nextLink -> listOfferingsNextSinglePageAsync(nextLink, acceptLanguage, context));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsSinglePage(String countryCode, Integer skip,
        Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType,
        String acceptLanguage) {
        return listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType,
            acceptLanguage).block();
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsSinglePage(String countryCode, Integer skip,
        Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType,
        String acceptLanguage, Context context) {
        return listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType,
            acceptLanguage, context).block();
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize,
        PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedIterable<>(
            listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage));
    }

    /**
     * List available offerings of capabilities with rates for the given country.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param phoneNumberType Filter by numberType, e.g. Geographic, TollFree, Mobile.
     * @param assignmentType Filter by assignmentType, e.g. Person, Application.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize,
        PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage,
        Context context) {
        return new PagedIterable<>(listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType,
            acceptLanguage, context));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsSinglePageAsync(Integer maxPageSize) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listReservations(this.client.getEndpoint(), this.client.getApiVersion(),
                maxPageSize, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getReservations(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsSinglePageAsync(Integer maxPageSize,
        Context context) {
        final String accept = "application/json";
        return service
            .listReservations(this.client.getEndpoint(), this.client.getApiVersion(), maxPageSize, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getReservations(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservationsAsync(Integer maxPageSize) {
        return new PagedFlux<>(() -> listReservationsSinglePageAsync(maxPageSize),
            nextLink -> listReservationsNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PhoneNumbersReservation> listReservationsAsync(Integer maxPageSize, Context context) {
        return new PagedFlux<>(() -> listReservationsSinglePageAsync(maxPageSize, context),
            nextLink -> listReservationsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsSinglePage(Integer maxPageSize) {
        return listReservationsSinglePageAsync(maxPageSize).block();
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsSinglePage(Integer maxPageSize, Context context) {
        return listReservationsSinglePageAsync(maxPageSize, context).block();
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize) {
        return new PagedIterable<>(listReservationsAsync(maxPageSize));
    }

    /**
     * Lists all reservations.
     * 
     * Retrieves a paginated list of all phone number reservations. Note that the reservations will not be populated
     * with the phone numbers associated with them.
     * 
     * @param maxPageSize An optional parameter for how many entries to return, for pagination purposes. The default
     * value is 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PhoneNumbersReservation> listReservations(Integer maxPageSize, Context context) {
        return new PagedIterable<>(listReservationsAsync(maxPageSize, context));
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservationWithResponseAsync(UUID reservationId,
        PhoneNumbersReservation reservation) {
        return FluxUtil
            .withContext(context -> createOrUpdateReservationWithResponseAsync(reservationId, reservation, context));
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> createOrUpdateReservationWithResponseAsync(UUID reservationId,
        PhoneNumbersReservation reservation, Context context) {
        final String accept = "application/json";
        return service.createOrUpdateReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId,
            reservation, accept, context);
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> createOrUpdateReservationAsync(UUID reservationId,
        PhoneNumbersReservation reservation) {
        return createOrUpdateReservationWithResponseAsync(reservationId, reservation)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> createOrUpdateReservationAsync(UUID reservationId,
        PhoneNumbersReservation reservation, Context context) {
        return createOrUpdateReservationWithResponseAsync(reservationId, reservation, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> createOrUpdateReservationWithResponse(UUID reservationId,
        PhoneNumbersReservation reservation, Context context) {
        return createOrUpdateReservationWithResponseAsync(reservationId, reservation, context).block();
    }

    /**
     * Creates or updates a reservation by its ID.
     * 
     * Adds and removes phone numbers from the reservation with the given ID. The response will be the updated state of
     * the reservation. Phone numbers can be reserved by including them in the payload. If a number is already in the
     * reservation, it will be ignored. To remove a phone number, set it explicitly to null in the request payload. This
     * operation is idempotent. If a reservation with the same ID already exists, it will be updated, otherwise a new
     * one is created. Only reservations with 'active' status can be updated. Updating a reservation will extend the
     * expiration time of the reservation to 15 minutes after the last change, up to a maximum of 2 hours from creation
     * time. Partial success is possible, in which case the response will have a 207 status code.
     * 
     * @param reservationId The id of the reservation.
     * @param reservation A representation of the desired state of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumbersReservation createOrUpdateReservation(UUID reservationId, PhoneNumbersReservation reservation) {
        return createOrUpdateReservationWithResponse(reservationId, reservation, Context.NONE).getValue();
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> getReservationWithResponseAsync(UUID reservationId) {
        return FluxUtil.withContext(context -> getReservationWithResponseAsync(reservationId, context));
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumbersReservation>> getReservationWithResponseAsync(UUID reservationId,
        Context context) {
        final String accept = "application/json";
        return service.getReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, accept,
            context);
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> getReservationAsync(UUID reservationId) {
        return getReservationWithResponseAsync(reservationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumbersReservation> getReservationAsync(UUID reservationId, Context context) {
        return getReservationWithResponseAsync(reservationId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumbersReservation> getReservationWithResponse(UUID reservationId, Context context) {
        return getReservationWithResponseAsync(reservationId, context).block();
    }

    /**
     * Gets a reservation by its ID.
     * 
     * Retrieves the reservation with the given ID, including all of the phone numbers associated with it.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a reservation for phone numbers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumbersReservation getReservation(UUID reservationId) {
        return getReservationWithResponse(reservationId, Context.NONE).getValue();
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteReservationWithResponseAsync(UUID reservationId) {
        return FluxUtil.withContext(context -> deleteReservationWithResponseAsync(reservationId, context));
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteReservationWithResponseAsync(UUID reservationId, Context context) {
        final String accept = "application/json";
        return service.deleteReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId, accept,
            context);
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteReservationAsync(UUID reservationId) {
        return deleteReservationWithResponseAsync(reservationId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteReservationAsync(UUID reservationId, Context context) {
        return deleteReservationWithResponseAsync(reservationId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteReservationWithResponse(UUID reservationId, Context context) {
        return deleteReservationWithResponseAsync(reservationId, context).block();
    }

    /**
     * Deletes a reservation by its ID.
     * 
     * Deletes the reservation with the given ID. Any phone number in the reservation will be released and made
     * available for others to purchase. Only reservations with 'active' status can be deleted.
     * 
     * @param reservationId The id of the reservation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteReservation(UUID reservationId) {
        deleteReservationWithResponse(reservationId, Context.NONE);
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservationWithResponseAsync(
        UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return FluxUtil.withContext(
            context -> purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, context));
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void>> purchaseReservationWithResponseAsync(
        UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        final String accept = "application/json";
        return service.purchaseReservation(this.client.getEndpoint(), this.client.getApiVersion(), reservationId,
            reservationPurchaseRequest, accept, context);
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purchaseReservationAsync(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purchaseReservationAsync(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersPurchaseReservationHeaders, Void> purchaseReservationWithResponse(
        UUID reservationId, PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return purchaseReservationWithResponseAsync(reservationId, reservationPurchaseRequest, context).block();
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purchaseReservation(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        purchaseReservationWithResponse(reservationId, reservationPurchaseRequest, Context.NONE);
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purchaseReservationNoCustomHeadersWithResponseAsync(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest) {
        return FluxUtil.withContext(context -> purchaseReservationNoCustomHeadersWithResponseAsync(reservationId,
            reservationPurchaseRequest, context));
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purchaseReservationNoCustomHeadersWithResponseAsync(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        final String accept = "application/json";
        return service.purchaseReservationNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            reservationId, reservationPurchaseRequest, accept, context);
    }

    /**
     * Starts the purchase of all phone numbers in the reservation.
     * 
     * Starts a long running operation to purchase all of the phone numbers in the reservation. Purchase can only be
     * started for active reservations that at least one phone number. If any of the phone numbers in the reservation is
     * from a country where reselling is not permitted, do not resell agreement is required. The response will include
     * an 'Operation-Location' header that can be used to query the status of the operation.
     * 
     * @param reservationId The id of the reservation.
     * @param reservationPurchaseRequest The reservationPurchaseRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purchaseReservationNoCustomHeadersWithResponse(UUID reservationId,
        PhoneNumbersReservationPurchaseRequest reservationPurchaseRequest, Context context) {
        return purchaseReservationNoCustomHeadersWithResponseAsync(reservationId, reservationPurchaseRequest, context)
            .block();
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>>
        searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        return FluxUtil
            .withContext(context -> searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context));
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>>
        searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body,
            Context context) {
        final String accept = "application/json";
        return service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(),
            body, accept, context);
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode,
        PhoneNumberSearchRequest body) {
        return searchAvailablePhoneNumbersWithResponseAsync(countryCode, body)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode,
        PhoneNumberSearchRequest body, Context context) {
        return searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersSearchAvailablePhoneNumbersHeaders, PhoneNumberSearchResult>
        searchAvailablePhoneNumbersWithResponse(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).block();
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumberSearchResult searchAvailablePhoneNumbers(String countryCode, PhoneNumberSearchRequest body) {
        return searchAvailablePhoneNumbersWithResponse(countryCode, body, Context.NONE).getValue();
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>>
        searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        return FluxUtil.withContext(
            context -> searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(countryCode, body, context));
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(
        String countryCode, PhoneNumberSearchRequest body, Context context) {
        final String accept = "application/json";
        return service.searchAvailablePhoneNumbersNoCustomHeaders(this.client.getEndpoint(), countryCode,
            this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Search for available phone numbers to purchase.
     * 
     * @param countryCode The ISO 3166-2 country code, e.g. US.
     * @param body The phone number search request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a phone number search operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumberSearchResult> searchAvailablePhoneNumbersNoCustomHeadersWithResponse(String countryCode,
        PhoneNumberSearchRequest body, Context context) {
        return searchAvailablePhoneNumbersNoCustomHeadersWithResponseAsync(countryCode, body, context).block();
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId) {
        return FluxUtil.withContext(context -> getSearchResultWithResponseAsync(searchId, context));
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId, Context context) {
        final String accept = "application/json";
        return service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId) {
        return getSearchResultWithResponseAsync(searchId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId, Context context) {
        return getSearchResultWithResponseAsync(searchId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumberSearchResult> getSearchResultWithResponse(String searchId, Context context) {
        return getSearchResultWithResponseAsync(searchId, context).block();
    }

    /**
     * Gets a phone number search result by search id.
     * 
     * @param searchId The search Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a phone number search result by search id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumberSearchResult getSearchResult(String searchId) {
        return getSearchResultWithResponse(searchId, Context.NONE).getValue();
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>>
        purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        return FluxUtil.withContext(context -> purchasePhoneNumbersWithResponseAsync(body, context));
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>>
        purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body, Context context) {
        final String accept = "application/json";
        return service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, accept,
            context);
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body) {
        return purchasePhoneNumbersWithResponseAsync(body).flatMap(ignored -> Mono.empty());
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body, Context context) {
        return purchasePhoneNumbersWithResponseAsync(body, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersPurchasePhoneNumbersHeaders, Void>
        purchasePhoneNumbersWithResponse(PhoneNumberPurchaseRequest body, Context context) {
        return purchasePhoneNumbersWithResponseAsync(body, context).block();
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purchasePhoneNumbers(PhoneNumberPurchaseRequest body) {
        purchasePhoneNumbersWithResponse(body, Context.NONE);
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purchasePhoneNumbersNoCustomHeadersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        return FluxUtil.withContext(context -> purchasePhoneNumbersNoCustomHeadersWithResponseAsync(body, context));
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purchasePhoneNumbersNoCustomHeadersWithResponseAsync(PhoneNumberPurchaseRequest body,
        Context context) {
        final String accept = "application/json";
        return service.purchasePhoneNumbersNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), body,
            accept, context);
    }

    /**
     * Purchases phone numbers.
     * 
     * @param body The phone number purchase request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purchasePhoneNumbersNoCustomHeadersWithResponse(PhoneNumberPurchaseRequest body,
        Context context) {
        return purchasePhoneNumbersNoCustomHeadersWithResponseAsync(body, context).block();
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>>
        getOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> getOperationWithResponseAsync(operationId, context));
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>>
        getOperationWithResponseAsync(String operationId, Context context) {
        final String accept = "application/json";
        return service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId) {
        return getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId, Context context) {
        return getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersGetOperationHeaders, PhoneNumberRawOperation>
        getOperationWithResponse(String operationId, Context context) {
        return getOperationWithResponseAsync(operationId, context).block();
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PhoneNumberRawOperation getOperation(String operationId) {
        return getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeadersWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> getOperationNoCustomHeadersWithResponseAsync(operationId, context));
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PhoneNumberRawOperation>> getOperationNoCustomHeadersWithResponseAsync(String operationId,
        Context context) {
        final String accept = "application/json";
        return service.getOperationNoCustomHeaders(this.client.getEndpoint(), operationId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Gets an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation by its id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PhoneNumberRawOperation> getOperationNoCustomHeadersWithResponse(String operationId,
        Context context) {
        return getOperationNoCustomHeadersWithResponseAsync(operationId, context).block();
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> cancelOperationWithResponseAsync(operationId, context));
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId, Context context) {
        final String accept = "application/json";
        return service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId) {
        return cancelOperationWithResponseAsync(operationId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId, Context context) {
        return cancelOperationWithResponseAsync(operationId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelOperationWithResponse(String operationId, Context context) {
        return cancelOperationWithResponseAsync(operationId, context).block();
    }

    /**
     * Cancels an operation by its id.
     * 
     * @param operationId The id of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelOperation(String operationId) {
        cancelOperationWithResponse(operationId, Context.NONE);
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>>
        updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return FluxUtil.withContext(context -> updateCapabilitiesWithResponseAsync(phoneNumber, body, context));
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>>
        updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        final String accept = "application/json";
        return service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body,
            accept, context);
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return updateCapabilitiesWithResponseAsync(phoneNumber, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body,
        Context context) {
        return updateCapabilitiesWithResponseAsync(phoneNumber, body, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersUpdateCapabilitiesHeaders, PurchasedPhoneNumber>
        updateCapabilitiesWithResponse(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return updateCapabilitiesWithResponseAsync(phoneNumber, body, context).block();
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PurchasedPhoneNumber updateCapabilities(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return updateCapabilitiesWithResponse(phoneNumber, body, Context.NONE).getValue();
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeadersWithResponseAsync(String phoneNumber,
        PhoneNumberCapabilitiesRequest body) {
        return FluxUtil
            .withContext(context -> updateCapabilitiesNoCustomHeadersWithResponseAsync(phoneNumber, body, context));
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> updateCapabilitiesNoCustomHeadersWithResponseAsync(String phoneNumber,
        PhoneNumberCapabilitiesRequest body, Context context) {
        final String accept = "application/json";
        return service.updateCapabilitiesNoCustomHeaders(this.client.getEndpoint(), phoneNumber,
            this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Updates the capabilities of a phone number.
     * 
     * @param phoneNumber The phone number id in E.164 format. The leading plus can be either + or encoded as %2B, e.g.
     * +11234567890.
     * @param body Defines the update capabilities request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a purchased phone number along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> updateCapabilitiesNoCustomHeadersWithResponse(String phoneNumber,
        PhoneNumberCapabilitiesRequest body, Context context) {
        return updateCapabilitiesNoCustomHeadersWithResponseAsync(phoneNumber, body, context).block();
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> getByNumberWithResponseAsync(phoneNumber, context));
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber, Context context) {
        final String accept = "application/json";
        return service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber) {
        return getByNumberWithResponseAsync(phoneNumber).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber, Context context) {
        return getByNumberWithResponseAsync(phoneNumber, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> getByNumberWithResponse(String phoneNumber, Context context) {
        return getByNumberWithResponseAsync(phoneNumber, context).block();
    }

    /**
     * Gets the details of the given purchased phone number.
     * 
     * @param phoneNumber The purchased phone number whose details are to be fetched in E.164 format, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the given purchased phone number.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PurchasedPhoneNumber getByNumber(String phoneNumber) {
        return getByNumberWithResponse(phoneNumber, Context.NONE).getValue();
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>>
        releasePhoneNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> releasePhoneNumberWithResponseAsync(phoneNumber, context));
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void>>
        releasePhoneNumberWithResponseAsync(String phoneNumber, Context context) {
        final String accept = "application/json";
        return service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber) {
        return releasePhoneNumberWithResponseAsync(phoneNumber).flatMap(ignored -> Mono.empty());
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber, Context context) {
        return releasePhoneNumberWithResponseAsync(phoneNumber, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PhoneNumbersReleasePhoneNumberHeaders, Void> releasePhoneNumberWithResponse(String phoneNumber,
        Context context) {
        return releasePhoneNumberWithResponseAsync(phoneNumber, context).block();
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void releasePhoneNumber(String phoneNumber) {
        releasePhoneNumberWithResponse(phoneNumber, Context.NONE);
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releasePhoneNumberNoCustomHeadersWithResponseAsync(String phoneNumber) {
        return FluxUtil
            .withContext(context -> releasePhoneNumberNoCustomHeadersWithResponseAsync(phoneNumber, context));
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releasePhoneNumberNoCustomHeadersWithResponseAsync(String phoneNumber,
        Context context) {
        final String accept = "application/json";
        return service.releasePhoneNumberNoCustomHeaders(this.client.getEndpoint(), phoneNumber,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Releases a purchased phone number.
     * 
     * @param phoneNumber Phone number to be released, e.g. +11234567890.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> releasePhoneNumberNoCustomHeadersWithResponse(String phoneNumber, Context context) {
        return releasePhoneNumberNoCustomHeadersWithResponseAsync(phoneNumber, context).block();
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listPhoneNumbers(this.client.getEndpoint(), skip, top,
                this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumbers(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top,
        Context context) {
        final String accept = "application/json";
        return service
            .listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumbers(), res.getValue().getNextLink(), null));
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top) {
        return new PagedFlux<>(() -> listPhoneNumbersSinglePageAsync(skip, top),
            nextLink -> listPhoneNumbersNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top, Context context) {
        return new PagedFlux<>(() -> listPhoneNumbersSinglePageAsync(skip, top, context),
            nextLink -> listPhoneNumbersNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersSinglePage(Integer skip, Integer top) {
        return listPhoneNumbersSinglePageAsync(skip, top).block();
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersSinglePage(Integer skip, Integer top, Context context) {
        return listPhoneNumbersSinglePageAsync(skip, top, context).block();
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top) {
        return new PagedIterable<>(listPhoneNumbersAsync(skip, top));
    }

    /**
     * Gets the list of all purchased phone numbers.
     * 
     * @param skip An optional parameter for how many entries to skip, for pagination purposes. The default value is 0.
     * @param top An optional parameter for how many entries to return, for pagination purposes. The default value is
     * 100.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all purchased phone numbers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top, Context context) {
        return new PagedIterable<>(listPhoneNumbersAsync(skip, top, context));
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>>
        operatorInformationSearchWithResponseAsync(OperatorInformationRequest body) {
        return FluxUtil.withContext(context -> operatorInformationSearchWithResponseAsync(body, context));
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>>
        operatorInformationSearchWithResponseAsync(OperatorInformationRequest body, Context context) {
        final String accept = "application/json";
        return service.operatorInformationSearch(this.client.getEndpoint(), this.client.getApiVersion(), body, accept,
            context);
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body) {
        return operatorInformationSearchWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body,
        Context context) {
        return operatorInformationSearchWithResponseAsync(body, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OperatorInformationResult> operatorInformationSearchWithResponse(OperatorInformationRequest body,
        Context context) {
        return operatorInformationSearchWithResponseAsync(body, context).block();
    }

    /**
     * Searches for number format and operator information for a given list of phone numbers.
     * 
     * @param body The phone number(s) whose number format and operator information should be searched.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a search result containing format and operator information associated with the requested phone
     * numbers.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperatorInformationResult operatorInformationSearch(OperatorInformationRequest body) {
        return operatorInformationSearchWithResponse(body, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink,
        String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAreaCodes(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink,
        String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getAreaCodes(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesNextSinglePage(String nextLink, String acceptLanguage) {
        return listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available area codes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberAreaCode> listAreaCodesNextSinglePage(String nextLink, String acceptLanguage,
        Context context) {
        return listAreaCodesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of countries along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink,
        String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(),
                acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getCountries(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of countries along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink,
        String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getCountries(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of countries along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesNextSinglePage(String nextLink,
        String acceptLanguage) {
        return listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of countries along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberCountry> listAvailableCountriesNextSinglePage(String nextLink,
        String acceptLanguage, Context context) {
        return listAvailableCountriesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of cities or towns along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink,
        String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(),
                acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberLocalities(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of cities or towns along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink,
        String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberLocalities(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of cities or towns along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesNextSinglePage(String nextLink,
        String acceptLanguage) {
        return listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of cities or towns along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberLocality> listAvailableLocalitiesNextSinglePage(String nextLink,
        String acceptLanguage, Context context) {
        return listAvailableLocalitiesNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink,
        String acceptLanguage) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberOfferings(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink,
        String acceptLanguage, Context context) {
        final String accept = "application/json";
        return service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumberOfferings(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsNextSinglePage(String nextLink, String acceptLanguage) {
        return listOfferingsNextSinglePageAsync(nextLink, acceptLanguage).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param acceptLanguage The locale to display in the localized fields in the response. e.g. 'en-US'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a wrapper around a list of offerings along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumberOffering> listOfferingsNextSinglePage(String nextLink, String acceptLanguage,
        Context context) {
        return listOfferingsNextSinglePageAsync(nextLink, acceptLanguage, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listReservationsNext(nextLink, this.client.getEndpoint(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getReservations(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumbersReservation>> listReservationsNextSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/json";
        return service.listReservationsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getReservations(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsNextSinglePage(String nextLink) {
        return listReservationsNextSinglePageAsync(nextLink).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a list of phone numbers reservations along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PhoneNumbersReservation> listReservationsNextSinglePage(String nextLink, Context context) {
        return listReservationsNextSinglePageAsync(nextLink, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of purchased phone numbers along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumbers(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of purchased phone numbers along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/json";
        return service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getPhoneNumbers(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of purchased phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersNextSinglePage(String nextLink) {
        return listPhoneNumbersNextSinglePageAsync(nextLink).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of purchased phone numbers along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<PurchasedPhoneNumber> listPhoneNumbersNextSinglePage(String nextLink, Context context) {
        return listPhoneNumbersNextSinglePageAsync(nextLink, context).block();
    }
}
