/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.CustomCallingContext;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.communication.common.PhoneNumberIdentifier;
import com.azure.communication.common.TeamsExtensionUserIdentifier;
import java.util.HashMap;

public final class TransferCallToParticipantOptions {
    private final CommunicationIdentifier targetParticipant;
    private final CustomCallingContext customCallingContext;
    private String operationCallbackUrl;
    private CommunicationIdentifier transferee;
    private String operationContext;
    private PhoneNumberIdentifier sourceCallerIdNumber;

    public TransferCallToParticipantOptions(CommunicationIdentifier targetParticipant) {
        this.targetParticipant = targetParticipant;
        this.customCallingContext = new CustomCallingContext(new HashMap<String, String>(), new HashMap<String, String>());
    }

    public TransferCallToParticipantOptions(CommunicationUserIdentifier targetParticipant) {
        this.targetParticipant = targetParticipant;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public TransferCallToParticipantOptions(PhoneNumberIdentifier targetParticipant) {
        this.targetParticipant = targetParticipant;
        this.customCallingContext = new CustomCallingContext(new HashMap<String, String>(), null);
    }

    public TransferCallToParticipantOptions(MicrosoftTeamsUserIdentifier targetParticipant) {
        this.targetParticipant = targetParticipant;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public TransferCallToParticipantOptions(TeamsExtensionUserIdentifier targetParticipant) {
        this.targetParticipant = targetParticipant;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public TransferCallToParticipantOptions setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public CommunicationIdentifier getTransferee() {
        return this.transferee;
    }

    public TransferCallToParticipantOptions setTransferee(CommunicationIdentifier transferee) {
        this.transferee = transferee;
        return this;
    }

    public CommunicationIdentifier getTargetParticipant() {
        return this.targetParticipant;
    }

    public CustomCallingContext getCustomCallingContext() {
        return this.customCallingContext;
    }

    public String getOperationCallbackUrl() {
        return this.operationCallbackUrl;
    }

    public TransferCallToParticipantOptions setOperationCallbackUrl(String operationCallbackUrl) {
        this.operationCallbackUrl = operationCallbackUrl;
        return this;
    }

    public PhoneNumberIdentifier getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    public TransferCallToParticipantOptions setSourceCallerIdNumber(PhoneNumberIdentifier sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }
}

