/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.TranscriptionDataContructorProxy;
import com.azure.communication.callautomation.implementation.converters.TranscriptionDataConverter;
import com.azure.communication.callautomation.models.StreamingData;
import com.azure.communication.callautomation.models.StreamingDataKind;
import com.azure.communication.callautomation.models.TextFormat;
import com.azure.communication.callautomation.models.TranscriptionResultState;
import com.azure.communication.callautomation.models.WordData;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.List;

public final class TranscriptionData
extends StreamingData {
    private static final ClientLogger LOGGER = new ClientLogger(TranscriptionData.class);
    private final String text;
    private final TextFormat format;
    private final Double confidence;
    private final Long offset;
    private final Long duration;
    private final List<WordData> words;
    private final CommunicationIdentifier participant;
    private final TranscriptionResultState resultState;

    protected TranscriptionData(TranscriptionDataConverter internalData) {
        super(StreamingDataKind.TRANSCRIPTION_DATA);
        this.text = internalData.getText();
        this.format = this.convertToTextFormatEnum(internalData.getFormat());
        this.confidence = internalData.getConfidence();
        this.offset = internalData.getOffset();
        this.duration = internalData.getDuration();
        this.words = internalData.getWords();
        this.participant = internalData.getParticipantRawID() != null && !internalData.getParticipantRawID().isEmpty() ? CommunicationIdentifier.fromRawId((String)internalData.getParticipantRawID()) : null;
        this.resultState = this.convertToResultStatusEnum(internalData.getResultStatus());
    }

    private TranscriptionResultState convertToResultStatusEnum(String resultStatus) {
        if ("Intermediate".equalsIgnoreCase(resultStatus)) {
            return TranscriptionResultState.INTERMEDIATE;
        }
        if ("Final".equalsIgnoreCase(resultStatus)) {
            return TranscriptionResultState.FINAL;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(resultStatus));
    }

    private TextFormat convertToTextFormatEnum(String format) {
        if ("Display".equalsIgnoreCase(format)) {
            return TextFormat.DISPLAY;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(format));
    }

    public String getText() {
        return this.text;
    }

    public TextFormat getFormat() {
        return this.format;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.duration * 100L);
    }

    public List<WordData> getTranscribedWords() {
        return this.words;
    }

    public CommunicationIdentifier getParticipant() {
        return this.participant;
    }

    public TranscriptionResultState getResultState() {
        return this.resultState;
    }

    static {
        TranscriptionDataContructorProxy.setAccessor(new TranscriptionDataContructorProxy.TranscriptionDataContructorProxyAccessor(){

            @Override
            public TranscriptionData create(TranscriptionDataConverter internalData) {
                return new TranscriptionData(internalData);
            }
        });
    }
}

