/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.RecordingStorage;
import com.azure.communication.callautomation.models.RecordingStorageType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class AzureBlobContainerRecordingStorage
extends RecordingStorage {
    private final RecordingStorageType recordingStorageType = RecordingStorageType.fromString("AzureBlobStorage");
    private String recordingDestinationContainerUrl;

    public AzureBlobContainerRecordingStorage(String recordingDestinationContainerUrl) {
        this.recordingDestinationContainerUrl = recordingDestinationContainerUrl;
    }

    public String getRecordingDestinationContainerUrl() {
        return this.recordingDestinationContainerUrl;
    }

    @Override
    public RecordingStorageType getRecordingStorageType() {
        return this.recordingStorageType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordingStorageType", this.recordingStorageType != null ? this.recordingStorageType.toString() : null);
        jsonWriter.writeStringField("recordingDestinationContainerUrl", this.recordingDestinationContainerUrl);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobContainerRecordingStorage fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobContainerRecordingStorage)jsonReader.readObject(reader -> {
            String recordingDestinationContainerUrl = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordingDestinationContainerUrl".equals(fieldName)) {
                    recordingDestinationContainerUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureBlobContainerRecordingStorage(recordingDestinationContainerUrl);
        });
    }
}

