/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.VoiceKindInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TextSourceInternal
implements JsonSerializable<TextSourceInternal> {
    private String text;
    private String sourceLocale;
    private VoiceKindInternal voiceKind;
    private String voiceName;
    private String customVoiceEndpointId;

    public String getText() {
        return this.text;
    }

    public TextSourceInternal setText(String text) {
        this.text = text;
        return this;
    }

    public String getSourceLocale() {
        return this.sourceLocale;
    }

    public TextSourceInternal setSourceLocale(String sourceLocale) {
        this.sourceLocale = sourceLocale;
        return this;
    }

    public VoiceKindInternal getVoiceKind() {
        return this.voiceKind;
    }

    public TextSourceInternal setVoiceKind(VoiceKindInternal voiceKind) {
        this.voiceKind = voiceKind;
        return this;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public TextSourceInternal setVoiceName(String voiceName) {
        this.voiceName = voiceName;
        return this;
    }

    public String getCustomVoiceEndpointId() {
        return this.customVoiceEndpointId;
    }

    public TextSourceInternal setCustomVoiceEndpointId(String customVoiceEndpointId) {
        this.customVoiceEndpointId = customVoiceEndpointId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("sourceLocale", this.sourceLocale);
        jsonWriter.writeStringField("voiceKind", this.voiceKind == null ? null : this.voiceKind.toString());
        jsonWriter.writeStringField("voiceName", this.voiceName);
        jsonWriter.writeStringField("customVoiceEndpointId", this.customVoiceEndpointId);
        return jsonWriter.writeEndObject();
    }

    public static TextSourceInternal fromJson(JsonReader jsonReader) throws IOException {
        return (TextSourceInternal)jsonReader.readObject(reader -> {
            TextSourceInternal deserializedTextSourceInternal = new TextSourceInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedTextSourceInternal.text = reader.getString();
                    continue;
                }
                if ("sourceLocale".equals(fieldName)) {
                    deserializedTextSourceInternal.sourceLocale = reader.getString();
                    continue;
                }
                if ("voiceKind".equals(fieldName)) {
                    deserializedTextSourceInternal.voiceKind = VoiceKindInternal.fromString(reader.getString());
                    continue;
                }
                if ("voiceName".equals(fieldName)) {
                    deserializedTextSourceInternal.voiceName = reader.getString();
                    continue;
                }
                if ("customVoiceEndpointId".equals(fieldName)) {
                    deserializedTextSourceInternal.customVoiceEndpointId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTextSourceInternal;
        });
    }
}

