/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.accesshelpers;

import com.azure.communication.callautomation.implementation.converters.AudioDataConverter;
import com.azure.communication.callautomation.models.AudioData;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;

public final class AudioDataContructorProxy {
    private static final ClientLogger LOGGER = new ClientLogger(AudioDataContructorProxy.class);
    private static AudioDataContructorProxyAccessor accessor;

    private AudioDataContructorProxy() {
    }

    public static void setAccessor(AudioDataContructorProxyAccessor accessor) {
        AudioDataContructorProxy.accessor = accessor;
    }

    public static AudioData create(AudioDataConverter internalResponse) {
        if (accessor == null) {
            try {
                Class.forName(AudioData.class.getName(), true, AudioDataContructorProxyAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        assert (accessor != null);
        return accessor.create(internalResponse);
    }

    public static AudioData create(BinaryData data) {
        if (accessor == null) {
            try {
                Class.forName(AudioData.class.getName(), true, AudioDataContructorProxyAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        assert (accessor != null);
        return accessor.create(data);
    }

    public static interface AudioDataContructorProxyAccessor {
        public AudioData create(AudioDataConverter var1);

        public AudioData create(BinaryData var1);
    }
}

