/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.models.events.MediaStreamingStatus;
import com.azure.communication.callautomation.models.events.MediaStreamingStatusDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MediaStreamingUpdateResult
implements JsonSerializable<MediaStreamingUpdateResult> {
    private String contentType;
    private MediaStreamingStatus mediaStreamingStatus;
    private MediaStreamingStatusDetails mediaStreamingStatusDetails;

    public String getContentType() {
        return this.contentType;
    }

    public MediaStreamingStatus getMediaStreamingStatus() {
        return this.mediaStreamingStatus;
    }

    public MediaStreamingStatusDetails getMediaStreamingStatusDetails() {
        return this.mediaStreamingStatusDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("mediaStreamingStatus", this.mediaStreamingStatus != null ? this.mediaStreamingStatus.toString() : null);
        jsonWriter.writeStringField("mediaStreamingStatusDetails", this.mediaStreamingStatusDetails != null ? this.mediaStreamingStatusDetails.toString() : null);
        return jsonWriter.writeEndObject();
    }

    public static MediaStreamingUpdateResult fromJson(JsonReader jsonReader) throws IOException {
        return (MediaStreamingUpdateResult)jsonReader.readObject(reader -> {
            MediaStreamingUpdateResult event = new MediaStreamingUpdateResult();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    event.contentType = reader.getString();
                    continue;
                }
                if ("mediaStreamingStatus".equals(fieldName)) {
                    event.mediaStreamingStatus = MediaStreamingStatus.fromString(reader.getString());
                    continue;
                }
                if ("mediaStreamingStatusDetails".equals(fieldName)) {
                    event.mediaStreamingStatusDetails = MediaStreamingStatusDetails.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return event;
        });
    }
}

