/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.VoiceKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TextSource
extends PlaySource {
    private String text;
    private String sourceLocale;
    private VoiceKind voiceKind;
    private String voiceName;
    private String customVoiceEndpointId;

    public String getText() {
        return this.text;
    }

    public TextSource setText(String text) {
        this.text = text;
        return this;
    }

    public String getSourceLocale() {
        return this.sourceLocale;
    }

    public TextSource setSourceLocale(String sourceLocale) {
        this.sourceLocale = sourceLocale;
        return this;
    }

    public VoiceKind getVoiceKind() {
        return this.voiceKind;
    }

    public TextSource setVoiceKind(VoiceKind voiceKind) {
        this.voiceKind = voiceKind;
        return this;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public TextSource setVoiceName(String voiceName) {
        this.voiceName = voiceName;
        return this;
    }

    public String getCustomVoiceEndpointId() {
        return this.customVoiceEndpointId;
    }

    public TextSource setCustomVoiceEndpointId(String customVoiceEndpointId) {
        this.customVoiceEndpointId = customVoiceEndpointId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("sourceLocale", this.sourceLocale);
        jsonWriter.writeStringField("voiceKind", this.voiceKind.toString());
        jsonWriter.writeStringField("voiceName", this.voiceName);
        jsonWriter.writeStringField("customVoiceEndpointId", this.customVoiceEndpointId);
        jsonWriter.writeStringField("playSourceCacheId", this.getPlaySourceCacheId());
        return jsonWriter.writeEndObject();
    }

    public static TextSource fromJson(JsonReader jsonReader) throws IOException {
        return (TextSource)jsonReader.readObject(reader -> {
            TextSource source = new TextSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    source.text = reader.getString();
                    continue;
                }
                if ("sourceLocale".equals(fieldName)) {
                    source.sourceLocale = reader.getString();
                    continue;
                }
                if ("voiceKind".equals(fieldName)) {
                    source.voiceKind = VoiceKind.fromString(reader.getString());
                    continue;
                }
                if ("voiceName".equals(fieldName)) {
                    source.voiceName = reader.getString();
                    continue;
                }
                if ("customVoiceEndpointId".equals(fieldName)) {
                    source.customVoiceEndpointId = reader.getString();
                    continue;
                }
                if ("playSourceCacheId".equals(fieldName)) {
                    source.setPlaySourceCacheId(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return source;
        });
    }
}

