/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RecognitionChoice
implements JsonSerializable<RecognitionChoice> {
    private String label;
    private List<String> phrases;
    private DtmfTone tone;

    public String getLabel() {
        return this.label;
    }

    public RecognitionChoice setLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> getPhrases() {
        return this.phrases;
    }

    public RecognitionChoice setPhrases(List<String> phrases) {
        this.phrases = phrases;
        return this;
    }

    public DtmfTone getTone() {
        return this.tone;
    }

    public RecognitionChoice setTone(DtmfTone tone) {
        this.tone = tone;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeArrayField("phrases", this.phrases, JsonWriter::writeString);
        jsonWriter.writeStringField("tone", this.tone.toString());
        return jsonWriter.writeEndObject();
    }

    public static RecognitionChoice fromJson(JsonReader jsonReader) throws IOException {
        return (RecognitionChoice)jsonReader.readObject(reader -> {
            RecognitionChoice choice = new RecognitionChoice();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("label".equals(fieldName)) {
                    choice.label = reader.getString();
                    continue;
                }
                if ("phrases".equals(fieldName)) {
                    choice.phrases = reader.readArray(JsonReader::getString);
                    continue;
                }
                if ("tone".equals(fieldName)) {
                    choice.tone = DtmfTone.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return choice;
        });
    }
}

