/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.AudioData;
import com.azure.communication.callautomation.models.MediaKind;
import com.azure.communication.callautomation.models.StopAudio;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Base64;

public final class OutStreamingData {
    private static final ClientLogger LOGGER = new ClientLogger(OutStreamingData.class);
    private final MediaKind kind;
    private AudioData audioData;
    private StopAudio stopAudio;

    OutStreamingData(MediaKind kind) {
        this.kind = kind;
    }

    MediaKind getMediaKind() {
        return this.kind;
    }

    AudioData getAudioData() {
        return this.audioData;
    }

    OutStreamingData setAudioData(BinaryData audioData) {
        this.audioData = new AudioData(audioData);
        return this;
    }

    OutStreamingData setStopAudio() {
        this.stopAudio = new StopAudio();
        return this;
    }

    public static String getStreamingDataForOutbound(BinaryData audioData) {
        try {
            OutStreamingData data = new OutStreamingData(MediaKind.AUDIO_DATA);
            data.setAudioData(audioData);
            return OutStreamingData.serializeOutStreamingData(data);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to serialize OutStreamingData", e));
        }
    }

    public static String getStopAudioForOutbound() {
        try {
            OutStreamingData data = new OutStreamingData(MediaKind.STOP_AUDIO);
            data.setStopAudio();
            return OutStreamingData.serializeOutStreamingData(data);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to serialize OutStreamingData", e));
        }
    }

    private static String serializeOutStreamingData(OutStreamingData data) throws IOException {
        StringWriter json = new StringWriter();
        try (JsonWriter jsonWriter = JsonProviders.createWriter((Writer)json);){
            data.toJson(jsonWriter);
        }
        return ((Object)json).toString();
    }

    private JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind.toString());
        if (this.audioData != null) {
            jsonWriter.writeFieldName("audioData");
            jsonWriter.writeStartObject();
            jsonWriter.writeStringField("data", Base64.getEncoder().encodeToString(this.audioData.getData().toBytes()));
            jsonWriter.writeNullField("timestamp");
            jsonWriter.writeNullField("participant");
            jsonWriter.writeBooleanField("isSilent", this.audioData.isSilent());
            jsonWriter.writeEndObject();
        }
        if (this.stopAudio != null) {
            jsonWriter.writeRawField("stopAudio", "{}");
        } else {
            jsonWriter.writeNullField("stopAudio");
        }
        jsonWriter.writeEndObject();
        return jsonWriter;
    }
}

