/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.CustomCallingContext;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.communication.common.PhoneNumberIdentifier;
import com.azure.communication.common.TeamsExtensionUserIdentifier;
import java.util.HashMap;

public final class CallInvite {
    private final CommunicationIdentifier targetParticipant;
    private PhoneNumberIdentifier sourceCallerIdNumber;
    private String sourceDisplayName;
    private final CustomCallingContext customCallingContext;

    public CallInvite(PhoneNumberIdentifier targetIdentity, PhoneNumberIdentifier callerIdNumber) {
        this.targetParticipant = targetIdentity;
        this.sourceCallerIdNumber = callerIdNumber;
        this.customCallingContext = new CustomCallingContext(new HashMap<String, String>(), null);
    }

    public CallInvite(CommunicationUserIdentifier targetIdentity) {
        this.targetParticipant = targetIdentity;
        this.sourceCallerIdNumber = null;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public CallInvite(MicrosoftTeamsUserIdentifier targetIdentity) {
        this.targetParticipant = targetIdentity;
        this.sourceCallerIdNumber = null;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public CallInvite(TeamsExtensionUserIdentifier targetIdentity) {
        this.targetParticipant = targetIdentity;
        this.sourceCallerIdNumber = null;
        this.customCallingContext = new CustomCallingContext(null, new HashMap<String, String>());
    }

    public CommunicationIdentifier getTargetParticipant() {
        return this.targetParticipant;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public CallInvite setSourceDisplayName(String sourceDisplayName) {
        this.sourceDisplayName = sourceDisplayName;
        return this;
    }

    public CustomCallingContext getCustomCallingContext() {
        return this.customCallingContext;
    }

    public PhoneNumberIdentifier getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    public CallInvite setSourceCallerIdNumber(PhoneNumberIdentifier sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }
}

