/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.StreamingTransportTypeInternal;
import com.azure.communication.callautomation.implementation.models.TranscriptionOptionsInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebSocketTranscriptionOptionsInternal
extends TranscriptionOptionsInternal {
    private StreamingTransportTypeInternal transportType = StreamingTransportTypeInternal.WEBSOCKET;
    private String transportUrl;
    private String speechModelEndpointId;
    private Boolean startTranscription;
    private Boolean enableIntermediateResults;

    @Override
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    public String getTransportUrl() {
        return this.transportUrl;
    }

    public WebSocketTranscriptionOptionsInternal setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
        return this;
    }

    public String getSpeechModelEndpointId() {
        return this.speechModelEndpointId;
    }

    public WebSocketTranscriptionOptionsInternal setSpeechModelEndpointId(String speechModelEndpointId) {
        this.speechModelEndpointId = speechModelEndpointId;
        return this;
    }

    public Boolean isStartTranscription() {
        return this.startTranscription;
    }

    public WebSocketTranscriptionOptionsInternal setStartTranscription(Boolean startTranscription) {
        this.startTranscription = startTranscription;
        return this;
    }

    public Boolean isEnableIntermediateResults() {
        return this.enableIntermediateResults;
    }

    public WebSocketTranscriptionOptionsInternal setEnableIntermediateResults(Boolean enableIntermediateResults) {
        this.enableIntermediateResults = enableIntermediateResults;
        return this;
    }

    @Override
    public WebSocketTranscriptionOptionsInternal setLocale(String locale) {
        super.setLocale(locale);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", this.getLocale());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        jsonWriter.writeStringField("transportUrl", this.transportUrl);
        jsonWriter.writeStringField("speechModelEndpointId", this.speechModelEndpointId);
        jsonWriter.writeBooleanField("startTranscription", this.startTranscription);
        jsonWriter.writeBooleanField("enableIntermediateResults", this.enableIntermediateResults);
        return jsonWriter.writeEndObject();
    }

    public static WebSocketTranscriptionOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return (WebSocketTranscriptionOptionsInternal)jsonReader.readObject(reader -> {
            WebSocketTranscriptionOptionsInternal deserializedWebSocketTranscriptionOptionsInternal = new WebSocketTranscriptionOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locale".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.setLocale(reader.getString());
                    continue;
                }
                if ("transportType".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.transportType = StreamingTransportTypeInternal.fromString(reader.getString());
                    continue;
                }
                if ("transportUrl".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.transportUrl = reader.getString();
                    continue;
                }
                if ("speechModelEndpointId".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.speechModelEndpointId = reader.getString();
                    continue;
                }
                if ("startTranscription".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.startTranscription = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableIntermediateResults".equals(fieldName)) {
                    deserializedWebSocketTranscriptionOptionsInternal.enableIntermediateResults = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebSocketTranscriptionOptionsInternal;
        });
    }
}

