/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CallLocatorInternal;
import com.azure.communication.callautomation.implementation.models.ChannelAffinityInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.RecordingChannelInternal;
import com.azure.communication.callautomation.implementation.models.RecordingContentInternal;
import com.azure.communication.callautomation.implementation.models.RecordingFormatInternal;
import com.azure.communication.callautomation.implementation.models.RecordingStorageInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class StartCallRecordingRequestInternal
implements JsonSerializable<StartCallRecordingRequestInternal> {
    private CallLocatorInternal callLocator;
    private String callConnectionId;
    private String recordingStateCallbackUri;
    private RecordingContentInternal recordingContentType;
    private RecordingChannelInternal recordingChannelType;
    private RecordingFormatInternal recordingFormatType;
    private List<CommunicationIdentifierModel> audioChannelParticipantOrdering;
    private List<ChannelAffinityInternal> channelAffinity;
    private Boolean pauseOnStart;
    private RecordingStorageInternal externalStorage;

    public CallLocatorInternal getCallLocator() {
        return this.callLocator;
    }

    public StartCallRecordingRequestInternal setCallLocator(CallLocatorInternal callLocator) {
        this.callLocator = callLocator;
        return this;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public StartCallRecordingRequestInternal setCallConnectionId(String callConnectionId) {
        this.callConnectionId = callConnectionId;
        return this;
    }

    public String getRecordingStateCallbackUri() {
        return this.recordingStateCallbackUri;
    }

    public StartCallRecordingRequestInternal setRecordingStateCallbackUri(String recordingStateCallbackUri) {
        this.recordingStateCallbackUri = recordingStateCallbackUri;
        return this;
    }

    public RecordingContentInternal getRecordingContentType() {
        return this.recordingContentType;
    }

    public StartCallRecordingRequestInternal setRecordingContentType(RecordingContentInternal recordingContentType) {
        this.recordingContentType = recordingContentType;
        return this;
    }

    public RecordingChannelInternal getRecordingChannelType() {
        return this.recordingChannelType;
    }

    public StartCallRecordingRequestInternal setRecordingChannelType(RecordingChannelInternal recordingChannelType) {
        this.recordingChannelType = recordingChannelType;
        return this;
    }

    public RecordingFormatInternal getRecordingFormatType() {
        return this.recordingFormatType;
    }

    public StartCallRecordingRequestInternal setRecordingFormatType(RecordingFormatInternal recordingFormatType) {
        this.recordingFormatType = recordingFormatType;
        return this;
    }

    public List<CommunicationIdentifierModel> getAudioChannelParticipantOrdering() {
        return this.audioChannelParticipantOrdering;
    }

    public StartCallRecordingRequestInternal setAudioChannelParticipantOrdering(List<CommunicationIdentifierModel> audioChannelParticipantOrdering) {
        this.audioChannelParticipantOrdering = audioChannelParticipantOrdering;
        return this;
    }

    public List<ChannelAffinityInternal> getChannelAffinity() {
        return this.channelAffinity;
    }

    public StartCallRecordingRequestInternal setChannelAffinity(List<ChannelAffinityInternal> channelAffinity) {
        this.channelAffinity = channelAffinity;
        return this;
    }

    public Boolean isPauseOnStart() {
        return this.pauseOnStart;
    }

    public StartCallRecordingRequestInternal setPauseOnStart(Boolean pauseOnStart) {
        this.pauseOnStart = pauseOnStart;
        return this;
    }

    public RecordingStorageInternal getExternalStorage() {
        return this.externalStorage;
    }

    public StartCallRecordingRequestInternal setExternalStorage(RecordingStorageInternal externalStorage) {
        this.externalStorage = externalStorage;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("callLocator", (JsonSerializable)this.callLocator);
        jsonWriter.writeStringField("callConnectionId", this.callConnectionId);
        jsonWriter.writeStringField("recordingStateCallbackUri", this.recordingStateCallbackUri);
        jsonWriter.writeStringField("recordingContentType", this.recordingContentType == null ? null : this.recordingContentType.toString());
        jsonWriter.writeStringField("recordingChannelType", this.recordingChannelType == null ? null : this.recordingChannelType.toString());
        jsonWriter.writeStringField("recordingFormatType", this.recordingFormatType == null ? null : this.recordingFormatType.toString());
        jsonWriter.writeArrayField("audioChannelParticipantOrdering", this.audioChannelParticipantOrdering, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("channelAffinity", this.channelAffinity, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("pauseOnStart", this.pauseOnStart);
        jsonWriter.writeJsonField("externalStorage", (JsonSerializable)this.externalStorage);
        return jsonWriter.writeEndObject();
    }

    public static StartCallRecordingRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return (StartCallRecordingRequestInternal)jsonReader.readObject(reader -> {
            StartCallRecordingRequestInternal deserializedStartCallRecordingRequestInternal = new StartCallRecordingRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("callLocator".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.callLocator = CallLocatorInternal.fromJson(reader);
                    continue;
                }
                if ("callConnectionId".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.callConnectionId = reader.getString();
                    continue;
                }
                if ("recordingStateCallbackUri".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingStateCallbackUri = reader.getString();
                    continue;
                }
                if ("recordingContentType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingContentType = RecordingContentInternal.fromString(reader.getString());
                    continue;
                }
                if ("recordingChannelType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingChannelType = RecordingChannelInternal.fromString(reader.getString());
                    continue;
                }
                if ("recordingFormatType".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.recordingFormatType = RecordingFormatInternal.fromString(reader.getString());
                    continue;
                }
                if ("audioChannelParticipantOrdering".equals(fieldName)) {
                    List audioChannelParticipantOrdering;
                    deserializedStartCallRecordingRequestInternal.audioChannelParticipantOrdering = audioChannelParticipantOrdering = reader.readArray(reader1 -> CommunicationIdentifierModel.fromJson(reader1));
                    continue;
                }
                if ("channelAffinity".equals(fieldName)) {
                    List channelAffinity;
                    deserializedStartCallRecordingRequestInternal.channelAffinity = channelAffinity = reader.readArray(reader1 -> ChannelAffinityInternal.fromJson(reader1));
                    continue;
                }
                if ("pauseOnStart".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.pauseOnStart = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("externalStorage".equals(fieldName)) {
                    deserializedStartCallRecordingRequestInternal.externalStorage = RecordingStorageInternal.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStartCallRecordingRequestInternal;
        });
    }
}

